% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reorder_layers.R
\name{reorder_layers}
\alias{reorder_layers}
\title{Move \code{basemap} land, glacier and grid layers on top of other ggplot layers}
\usage{
reorder_layers(p)
}
\arguments{
\item{p}{ggplot object from the \code{\link{basemap}} function.}
}
\value{
Returns a ggplot object with land, glacier and grid layers on top.
}
\description{
Moves existing land, glacier and grid layers on top of other layers. Useful for hiding region polygons under land.
}
\details{
This function has not been tested properly yet and is likely to contain bugs.
}
\examples{
if(requireNamespace("ggOceanMapsData", quietly = TRUE)) {
 \donttest{
 data("ices_areas")
 p <- basemap(c(-20, 15, 50, 70)) + 
   annotation_spatial(ices_areas, aes(fill = Area_Full), show.legend = FALSE)
 
 # Polygons on top of land
 p
 
 # Move land on top
 reorder_layers(p)
 }
 }
}
\seealso{
Other customize shapefiles: 
\code{\link{auto_limits}()},
\code{\link{theme_map}()}
}
\author{
Mikko Vihtakari
}
\concept{customize shapefiles}
