% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmx_read_nm_files.R
\name{pmx_read_nm_files}
\alias{pmx_read_nm_files}
\title{NONMEM output file import function}
\usage{
pmx_read_nm_files(
  runno = NULL,
  prefix = "run",
  ext = c(".ext", ".cor", ".cov", ".phi", ".grd", ".shk"),
  file = NULL,
  dir = NULL,
  quiet = FALSE
)
}
\arguments{
\item{runno}{Run number to be evaluated.}

\item{prefix}{Prefix of the model file names.}

\item{ext}{A vector of the file extension to import. By default '.ext', '.cor', '.cov', '.phi', '.grd', '.shk'
files are listed.}

\item{file}{Names of the model output file to be imported. Alternative argument to \code{prefix},
\code{runno} and \code{ext}.}

\item{dir}{Location of the model files.}

\item{quiet}{Logical, if \code{FALSE} messages are printed to the console.}
}
\description{
Quickly import NONMEM output files into R.
}
\examples{
\dontrun{
# Using the `file` argument to import a model file:
ext_file <- pmx_read_nm_files(file = 'run001.ext', dir = 'models')

# Using the `runno` argument to import a model file:
ext_file <- pmx_read_nm_files(runno = '001', ext = '.ext', dir = 'models')
}
}
