% Generated by roxygen2 (4.0.2): do not edit by hand
\name{gg_variable.ggRandomForests}
\alias{gg_variable}
\alias{gg_variable.ggRandomForests}
\alias{gg_variable.rfsrc}
\title{Marginal variable depedance data object.}
\usage{
gg_variable.ggRandomForests(object, time, time.labels, oob = TRUE, ...)
}
\arguments{
\item{object}{a \code{randomForestSRC::rfsrc} object}

\item{time}{point (or vector of points) of interest (for survival forests only)}

\item{time.labels}{If more than one time is specified, a vector of time.labels
for differentiating the time points (for survival forests only)}

\item{oob}{indicate if predicted results should include oob or full data set.}

\item{...}{extra arguments}
}
\value{
A matrix for creating the marginal variable dependence plots.
}
\description{
\code{randomForestSRC::plot.variable} generates a \code{data.frame}
 containing the marginal variable dependance or the partial variable dependence.
 The \code{gg_variable} function creates a \code{data.frame} of containing the
 full set of covariate data (predictor variables) and the predicted response for
 each observation. Marginal dependence figures are created using the
 \code{\link{plot.gg_variable}} function.
}
\details{
The marginal variable dependence is determined by comparing relation
between the predicted response from the randomforest and a covariate of interest.

The \code{gg_variable} function operates on a \code{randomForestSRC::rfsrc} object,
or the output from the \code{randomForestSRC::plot.variable} function.
}
\examples{
## ------------------------------------------------------------
## classification
## ------------------------------------------------------------

## iris
#iris.obj <- rfsrc(Species ~., data = iris)
data(iris_rf, package="ggRandomForests")

gg_dta <- gg_variable(iris_rf)
plot(gg_dta, x_var="Sepal.Width")
plot(gg_dta, x_var="Sepal.Length")

## ------------------------------------------------------------
## regression
## ------------------------------------------------------------

## airquality
#airq.obj <- rfsrc(Ozone ~ ., data = airquality)
data(airq_rf, package="ggRandomForests")
gg_dta <- gg_variable(airq_rf)
plot(gg_dta, x_var="Wind")
plot(gg_dta, x_var="Temp")
plot(gg_dta, x_var="Solar.R")

## motor trend cars
#mtcars.obj <- rfsrc(mpg ~ ., data = mtcars)
data(mtcars_rf, package="ggRandomForests")
gg_dta <- gg_variable(mtcars_rf)

# mtcars$cyl is an ordinal variable
gg_dta$cyl <- factor(gg_dta$cyl)
plot(gg_dta, x_var="cyl")

# Others are continuous
plot(gg_dta, x_var="disp")
plot(gg_dta, x_var="hp")
plot(gg_dta, x_var="wt")

# panel
plot(gg_dta, x_var=c("disp","hp"), panel=TRUE)

## ------------------------------------------------------------
## survival examples
## ------------------------------------------------------------

## survival
# data(veteran, package = "randomForestSRC")
# veteran_rf <- rfsrc(Surv(time,status)~., veteran, nsplit = 10, ntree = 100)
data(veteran_rf, package="ggRandomForests")

# get the 1 year survival time.
gg_dta <- gg_variable(veteran_rf, time=90)

# Generate variable dependance plots for age and diagtime
plot(gg_dta, x_var = "age")
plot(gg_dta, x_var = "diagtime")

# Generate coplots
plot(gg_dta, x_var = c("age", "diagtime"), panel=TRUE)

# If we want to compare survival at different time points, say 30, 90 day
# and 1 year
gg_dta <- gg_variable(veteran_rf, time=c(30, 90, 365))

# Generate variable dependance plots for age and diagtime
plot(gg_dta, x_var = "age")
plot(gg_dta, x_var = "diagtime")

# Generate coplots
plot(gg_dta, x_var =  c("age", "diagtime"), panel=TRUE)
}
\seealso{
\code{\link{plot.gg_variable}} \code{randomForestSRC::plot.variable}
}

