% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggVennDiagram.R
\name{ggVennDiagram}
\alias{ggVennDiagram}
\title{ggVennDiagram main parser}
\usage{
ggVennDiagram(
  x,
  category.names = names(x),
  show_intersect = FALSE,
  set_color = "black",
  set_size = NA,
  label = c("both", "count", "percent", "none"),
  label_alpha = 0.5,
  label_geom = c("label", "text"),
  label_color = "black",
  label_size = NA,
  label_percent_digit = 0,
  label_txtWidth = 40,
  edge_lty = "solid",
  edge_size = 1,
  force_upset = FALSE,
  nintersects = 20,
  order.intersect.by = c("size", "name", "none"),
  order.set.by = c("size", "name", "none"),
  relative_height = 3,
  relative_width = 0.3,
  ...
)
}
\arguments{
\item{x}{list of items}

\item{category.names}{default is names(x)}

\item{show_intersect}{if TRUE the text can be visualized by `plotly`}

\item{set_color}{color of set labels ("black")}

\item{set_size}{size of set labels (NA)}

\item{label}{format of region labels, select one from c("count","percent","both","none")}

\item{label_alpha}{set 0 to remove the background of region labels}

\item{label_geom}{layer of region labels, choose from c("label", "text")}

\item{label_color}{color of region labels ("black")}

\item{label_size}{size of region labels (NA)}

\item{label_percent_digit}{number of digits when formatting percent label (0)}

\item{label_txtWidth}{width of text used in showing intersect members, will be ignored unless show_intersection is TRUE (40)}

\item{edge_lty}{line type of set edges ("solid")}

\item{edge_size}{line width of set edges (1)}

\item{force_upset}{if TRUE, will always produce Upset plot no matter how many sets have (FALSE)}

\item{nintersects}{number of intersects. If NULL, all intersections will show.}

\item{order.intersect.by}{'size', 'name', or "none"}

\item{order.set.by}{'size', 'name', or "none"}

\item{relative_height}{the relative height of top panel in upset plot}

\item{relative_width}{the relative width of left panel in upset plot}

\item{...}{useless}
}
\value{
A ggplot object
}
\description{
ggVennDiagram main parser
}
\details{
From version 1.4.4, `ggVennDiagram` will plot a upset plot when the number of sets
is more than 7. Besides, user can switch to a upset plot with `upset_plot()` function.
Please check the document of this function.
}
\examples{
library(ggVennDiagram)
x = list(A=1:5,B=2:7,C=3:6,D=4:9)
ggVennDiagram(x)  # 4d venn
ggVennDiagram(x[1:3])  # 3d venn
ggVennDiagram(x[1:2])  # 2d venn
}
