% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align-kmeans.R
\name{align_kmeans}
\alias{align_kmeans}
\title{Split layout by k-means clustering groups.}
\usage{
align_kmeans(
  centers,
  iter.max = 10,
  nstart = 1,
  algorithm = c("Hartigan-Wong", "Lloyd", "Forgy", "MacQueen"),
  trace = FALSE,
  data = NULL,
  set_context = FALSE,
  name = NULL
)
}
\arguments{
\item{centers}{either the number of clusters, say \eqn{k}, or a set of
    initial (distinct) cluster centres.  If a number, a random set of
    (distinct) rows in \code{x} is chosen as the initial centres.}

\item{iter.max}{the maximum number of iterations allowed.}

\item{nstart}{if \code{centers} is a number, how many random sets
    should be chosen?}

\item{algorithm}{character: may be abbreviated.  Note that
    \code{"Lloyd"} and \code{"Forgy"} are alternative names for one
    algorithm.}

\item{trace}{logical or integer number, currently only used in the
    default method (\code{"Hartigan-Wong"}): if positive (or true),
    tracing information on the progress of the algorithm is
    produced.  Higher values may produce more tracing information.}

\item{data}{A matrix, a data frame, or even a simple vector that will be
converted into a one-column matrix. If the \code{data} argument is set to \code{NULL},
the \verb{align_*} will use the \code{layout} data. Additionally, the \code{data} argument
can also accept a function (purrr-like lambda is also okay), which will be
applied with the \code{layout} data,

It is important to note that all \verb{align_*} functions consider the \code{rows} as
the observations. It means the \code{NROW(data)} must return the same number with
the parallel \code{layout} axis.
\itemize{
\item \code{layout_heatmap}: for column annotation, the \code{layout} data will be
transposed before using (If data is a \code{function}, it will be applied with
the transposed matrix). This is necessary because column annotation uses
heatmap columns as observations, but we need rows.
\item \code{layout_stack}: the \code{layout} data will be used as it is since we place all
plots along a single axis.
}}

\item{set_context}{A single boolean value indicates whether to set the active
context to current plot. If \code{TRUE}, all subsequent ggplot elements will be
added into this plot.}

\item{name}{A string of the plot name. Used to switch the active context in
\code{\link[=hmanno]{hmanno()}} or \code{\link[=stack_active]{stack_active()}}.}
}
\value{
A new \code{Align} object.
}
\description{
Split layout by k-means clustering groups.
}
\examples{
ggheatmap(matrix(rnorm(81), nrow = 9)) +
    hmanno("t") +
    align_kmeans(3L)
}
