% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignpatch-area.R
\name{area}
\alias{area}
\title{Define the plotting areas in \code{align_plots}}
\usage{
area(t, l, b = t, r = l)
}
\arguments{
\item{t, b}{The top and bottom bounds of the area in the grid}

\item{l, r}{The left and right bounds of the area int the grid}
}
\value{
A \code{align_area} object.
}
\description{
This is a small helper used to specify a single area in a rectangular grid
that should contain a plot. Objects constructed with \code{area()} can be
concatenated together with \code{c()} in order to specify multiple areas.
}
\details{
The grid that the areas are specified in reference to enumerate rows from top
to bottom, and coloumns from left to right. This means that \code{t} and \code{l}
should always be less or equal to \code{b} and \code{r} respectively. Instead of
specifying area placement with a combination of \code{area()} calls, it is
possible to instead pass in a single string

\if{html}{\out{<div class="sourceCode">}}\preformatted{areas <- c(area(1, 1, 2, 1),
           area(2, 3, 3, 3))
}\if{html}{\out{</div>}}

is equivalent to

\if{html}{\out{<div class="sourceCode">}}\preformatted{areas < -"A##
          A#B
          ##B"
}\if{html}{\out{</div>}}
}
\examples{
p1 <- ggplot(mtcars) +
    geom_point(aes(mpg, disp))
p2 <- ggplot(mtcars) +
    geom_boxplot(aes(gear, disp, group = gear))
p3 <- ggplot(mtcars) +
    geom_bar(aes(gear)) +
    facet_wrap(~cyl)

layout <- c(
    area(1, 1),
    area(1, 3, 3),
    area(3, 1, 3, 2)
)

# Show the layout to make sure it looks as it should
plot(layout)

# Apply it to a alignpatches
align_plots(p1, p2, p3, design = layout)
}
