% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout-heatmap-.R
\name{heatmap_layout}
\alias{heatmap_layout}
\alias{ggheatmap}
\title{Arrange Plots in a Heatmap}
\usage{
heatmap_layout(
  data = NULL,
  mapping = aes(),
  ...,
  width = NA,
  height = NA,
  filling = waiver(),
  theme = NULL,
  active = NULL,
  set_context = deprecated(),
  order = deprecated(),
  name = deprecated(),
  guides = deprecated()
)
}
\arguments{
\item{data}{Default dataset to use for the layout. If not specified, it must be supplied in each plot added to the layout. By default, it will try to inherit from parent layout. If not already a matrix, will be converted
to one by \code{\link[=fortify_matrix]{fortify_matrix()}}.}

\item{mapping}{Default list of aesthetic mappings to use for plot.
If not specified, must be supplied in each layer added to the plot.}

\item{...}{Additional arguments passed to \code{\link[=fortify_matrix]{fortify_matrix()}}.}

\item{width, height}{The relative width/height of the main plot, can be a
\code{\link[grid:unit]{unit}} object.}

\item{filling}{A single string of \code{"raster"} or \code{"tile"} to
indicate the filling style. By default, \code{waiver()} is used, which means that
if the input matrix has more than 20,000 cells (\code{nrow * ncol > 20000}),
\code{\link[ggplot2:geom_tile]{geom_raster()}} will be used for performance
efficiency; for smaller matrices, \code{\link[ggplot2:geom_tile]{geom_tile()}} will be
used. To customize the filling style, set this to \code{NULL}.

For backward compatibility, a single boolean value is acceptable: \code{TRUE}
means \code{waiver()}, and \code{FALSE} means \code{NULL}.

By default, the classic heatmap color scheme
\code{\link[ggplot2:scale_gradient]{scale_fill_gradient2(low = "blue", high = "red")}}
is utilized for continuous values.

You can use the options
\code{"ggalign.heatmap_continuous_fill"} or
\code{"ggalign.heatmap_discrete_fill"} to modify the
default heatmap body filling color scale. See
\code{\link[ggplot2:scale_colour_continuous]{scale_fill_continuous()}} or
\code{\link[ggplot2:scale_colour_discrete]{scale_fill_discrete()}} for details on
option settings.}

\item{theme}{A \code{\link[ggplot2:theme]{theme()}} used to render the \code{guides},
\code{title}, \code{subtitle}, \code{caption}, \code{margins}, \code{patch.title}, \code{panel.border}, and
\code{background}. If \code{NULL} (default), will inherit from the parent \code{layout}.}

\item{active}{A \code{\link[=active]{active()}} object that defines the context settings when
added to a layout.}

\item{set_context}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use \code{active}
argument instead.}

\item{order}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use \code{active} argument
instead.}

\item{name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use \code{active} argument
instead.}

\item{guides}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=plot_align]{plot_align()}} function instead.}
}
\value{
A \code{HeatmapLayout} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{heatmap_layout} is a specialized version of \code{\link[=quad_alignb]{quad_alignb()}}, which
simplifies the creation of heatmap plots by integrating essential elements
for a standard heatmap layout, ensuring that the appropriate data mapping and
visualization layers are automatically applied. \code{ggheatmap} is an alias for
\code{heatmap_layout}.
}
\section{ggplot2 specification}{

The data input in \code{ggheatmap} will be converted into the long formated data
frame when drawing. The default mapping will use \code{aes(.data$.x, .data$.y)},
you can use \code{mapping} argument to control it. The data in the underlying
\code{ggplot} object contains following columns:
\itemize{
\item \code{.xpanel} and \code{.ypanel}: the column and row panel
\item \code{.x} and \code{.y}: the \code{x} and \code{y} coordinates
\item \code{.row_names} and \code{.column_names}: A factor of the row and column names of
the original matrix (only applicable when names exist).
\item \code{.row_index} and \code{.column_index}: the row and column index of the original
matrix.
\item \code{value}: the actual matrix value.
}
}

\examples{
ggheatmap(1:10)
ggheatmap(letters)
ggheatmap(matrix(rnorm(81), nrow = 9L))
}
