% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{.link_draw}
\alias{.link_draw}
\title{Define the links to connect a pair of observations}
\usage{
.link_draw(.draw, ...)
}
\arguments{
\item{.draw}{A function used to draw the links. The function must return a
\code{\link[grid:grid.grob]{grob()}} object. If the function does not return a valid
\code{grob}, no drawing will occur. The input data for the function should be
a list, where each item is a data frame containing the coordinates of
the pair of observations.}

\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> A list of formulas, where each side
of the formula should be an \code{integer} or \code{character} index of the original
data, or a \code{range_link()} object defining the linked observations. Use
\code{NULL} to indicate no link on that side. You can also combine these by
wrapping them into a single \code{list()}. If only the left-hand side of the
formula exists, you can input it directly. For integer indices, wrap them
with \code{\link[=I]{I()}} to use the ordering from the layout. You can also use
\code{\link[ggplot2:waiver]{waiver()}} to inherit values from the other group.}
}
\description{
A base version of \code{\link[=link_draw]{link_draw()}}, optimized for performance. This function
serves as the foundation for building other \verb{link_*} functions that manage
the drawing of links between pairs of observations.
}
\seealso{
\code{\link[=link_draw]{link_draw()}}
}
