% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify-matrix-list.R
\name{fortify_matrix.list_upset}
\alias{fortify_matrix.list_upset}
\alias{fortify_matrix.list}
\title{Build a Matrix for UpSet plot}
\usage{
\method{fortify_matrix}{list_upset}(data, mode = "distinct", ..., data_arg = NULL, call = NULL)
}
\arguments{
\item{data}{A list of sets.}

\item{mode}{A string of \code{"distinct"}, \code{"intersect"}, or \code{"union"}
indicates the mode to define the set intersections. Check
\url{https://jokergoo.github.io/ComplexHeatmap-reference/book/upset-plot.html#upset-mode}
for details.}

\item{...}{These dots are for future extensions and must be empty.}

\item{data_arg}{The argument name for \code{data}. Developers can use it to
improve messages. Not used by the user.}

\item{call}{The execution environment where \code{data} and other arguments for
the method are collected. Developers can use it to improve messages. Not
used by the user.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function converts a list into a matrix format suitable for creating an
UpSet plot. It always returns a matrix for a \code{horizontal} UpSet plot.
}
\section{ggalign attributes}{

\itemize{
\item \code{intersection_sizes}: An integer vector indicating the size of each
intersection.
\item \code{set_sizes}: An integer vector indicating the size of each set.
}
}

\seealso{
\code{\link[=tune.list]{tune.list()}}

Other \code{\link[=fortify_matrix]{fortify_matrix()}} methods:
\code{\link{fortify_matrix.GISTIC}()},
\code{\link{fortify_matrix.MAF}()},
\code{\link{fortify_matrix.default}()},
\code{\link{fortify_matrix.matrix}()},
\code{\link{fortify_matrix.matrix_oncoplot}()},
\code{\link{fortify_matrix.matrix_upset}()},
\code{\link{fortify_matrix.phylo}()}
}
\concept{fortify_matrix}
