% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scheme-.R
\name{Schemes}
\alias{Schemes}
\title{A container for multiple layout schemes}
\usage{
Schemes(...)
}
\arguments{
\item{...}{<\link[rlang:dyn-dots]{dyn-dots}> A list of \code{\link{Scheme}} object.}
}
\description{
\code{Schemes} is a container class that holds a list of \code{Scheme} objects, each
uniquely identified by their \code{key} property (usually derived from the class
name). It is used internally by the \code{ggalign} system to manage sets of layout
or rendering configurations that can be inherited, updated, or applied during
plot composition.
}
\section{Keys and Validation}{

\itemize{
\item Each \code{Scheme} in the container must have a unique key.
\item The key is used to reference and update individual schemes.
}
}

\section{Accessors}{

\itemize{
\item \code{value}: The underlying list of \code{Scheme} objects.
\item \code{entries}: A named list of schemes, where names are derived from their
keys.
\item \code{keys}: A character vector of all scheme keys.
}
}

\seealso{
\code{\link{Scheme}}
}
\keyword{internal}
