% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fortify-matrix-matrix.R
\name{fortify_matrix.matrix_oncoplot}
\alias{fortify_matrix.matrix_oncoplot}
\title{Build a Matrix for OncoPrint}
\usage{
\method{fortify_matrix}{matrix_oncoplot}(
  data,
  ...,
  genes = NULL,
  n_top = NULL,
  remove_empty_genes = TRUE,
  remove_empty_samples = TRUE,
  missing_genes = "error",
  data_arg = NULL,
  call = NULL
)
}
\arguments{
\item{data}{A matrix where each row represents an genes, and each column
represents samples. The values in the matrix indicate whether the element is
part of the set.}

\item{...}{These dots are for future extensions and must be empty.}

\item{genes}{An atomic character defines the genes to draw.}

\item{n_top}{A single number indicates how many top genes to be drawn.}

\item{remove_empty_genes}{A single boolean value indicats whether to drop
genes without any genomic alterations.}

\item{remove_empty_samples}{A single boolean value indicats whether to drop
samples without any genomic alterations.}

\item{missing_genes}{A string, either \code{"error"} or \code{"remove"}, specifying the
action for handling missing genes.}

\item{data_arg}{The argument name for \code{data}. Developers can use it to
improve messages. Not used by the user.}

\item{call}{The execution environment where \code{data} and other arguments for
the method are collected. Developers can use it to improve messages. Not
used by the user.}
}
\description{
Converts a matrix suitable for creating an OncoPrint. \code{\link[=tune.matrix]{tune.matrix()}}
helps convert \code{matrix} object to a \code{matrix_oncoplot} object.
}
\section{ggalign attributes}{

\itemize{
\item \code{gene_summary}: An integer vector of the altered samples for each gene.
\item \code{sample_summary}: An integer vector of the altered genes for each sample.
\item \code{n_genes}: Total number of genes.
\item \code{n_samples}: Total number of samples.
}
}

\seealso{
\code{\link[=tune.matrix]{tune.matrix()}}

Other \code{\link[=fortify_matrix]{fortify_matrix()}} methods:
\code{\link{fortify_matrix.GISTIC}()},
\code{\link{fortify_matrix.MAF}()},
\code{\link{fortify_matrix.default}()},
\code{\link{fortify_matrix.list_upset}()},
\code{\link{fortify_matrix.matrix}()},
\code{\link{fortify_matrix.matrix_upset}()}
}
\concept{fortify_matrix}
