% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-stratum.r
\name{geom_stratum}
\alias{geom_stratum}
\title{Strata at axes}
\usage{
geom_stratum(mapping = NULL, data = NULL, stat = "stratum",
  position = "identity", show.legend = NA, inherit.aes = TRUE,
  width = 1/3, axis_width = NULL, na.rm = FALSE, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{stat}{The statistical transformation to use on the data;
override the default.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{width}{Numeric; the width of each stratum, as a proportion of the
distance between axes. Defaults to 1/3.}

\item{axis_width}{Deprecated; alias for \code{width}.}

\item{na.rm}{Logical:
if \code{FALSE}, the default, \code{NA} lodes are not included;
if \code{TRUE}, \code{NA} lodes constitute a separate category,
plotted in grey (regardless of the color scheme).}

\item{...}{Additional arguments passed to \code{\link[ggplot2]{layer}}.}
}
\description{
\code{geom_stratum} receives a dataset of the horizontal (\code{x}) and
vertical (\code{y}, \code{ymin}, \code{ymax}) positions of the strata of an
alluvial diagram.
It plots rectangles for these strata of a provided \code{width}.
}
\section{Aesthetics}{

\code{geom_stratum} understands the following aesthetics
(required aesthetics are in bold):
\itemize{
  \item \strong{\code{x}}
  \item \strong{\code{y}}
  \item \strong{\code{ymin}}
  \item \strong{\code{ymax}}
  \item \code{alpha}
  \item \code{colour}
  \item \code{fill}
  \item \code{linetype}
  \item \code{size}
  \item \code{group}
}
\code{group} is used internally; arguments are ignored.
}

\examples{
# full axis width
ggplot(as.data.frame(Titanic),
       aes(weight = Freq,
           axis1 = Class, axis2 = Sex, axis3 = Age, axis4 = Survived)) +
  geom_stratum(width = 1) + geom_text(stat = "stratum", label.strata = TRUE) +
  scale_x_continuous(breaks = 1:4,
                     labels = c("Class", "Sex", "Age", "Survived"))
  
# use of facets
ggplot(as.data.frame(Titanic),
       aes(weight = Freq,
           axis1 = Class, axis2 = Sex)) +
  geom_flow(aes(fill = Survived)) +
  geom_stratum() + geom_text(stat = "stratum", label.strata = TRUE) +
  scale_x_continuous(breaks = 1:2, labels = c("Class", "Sex")) +
  facet_wrap(~ Age, scales = "free_y")
}
\seealso{
\code{\link[ggplot2]{layer}} for additional arguments, and
  \code{\link{stat_stratum}} for the corresponding geom.
}
