% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_crossbar.R
\name{gg_crossbar}
\alias{gg_crossbar}
\title{Crossbar ggplot}
\usage{
gg_crossbar(
  data = NULL,
  ...,
  stat = "identity",
  position = "identity",
  coord = ggplot2::coord_cartesian(clip = "off"),
  theme = NULL,
  theme_orientation = NULL,
  theme_axis_line_rm = NULL,
  theme_axis_ticks_rm = NULL,
  theme_panel_grid_rm = NULL,
  blend = NULL,
  x = NULL,
  xmin = NULL,
  xmax = NULL,
  xend = NULL,
  y = NULL,
  ymin = NULL,
  ymax = NULL,
  yend = NULL,
  z = NULL,
  col = NULL,
  facet = NULL,
  facet2 = NULL,
  group = NULL,
  subgroup = NULL,
  label = NULL,
  text = NULL,
  sample = NULL,
  mapping = NULL,
  x_breaks = NULL,
  x_breaks_n = NULL,
  x_expand = NULL,
  x_expand_limits = NULL,
  x_label = NULL,
  x_labels = NULL,
  x_position = "bottom",
  x_sec_axis = ggplot2::waiver(),
  x_symmetric = NULL,
  x_transform = NULL,
  y_breaks = NULL,
  y_breaks_n = NULL,
  y_expand = NULL,
  y_expand_limits = NULL,
  y_label = NULL,
  y_labels = NULL,
  y_position = "left",
  y_sec_axis = ggplot2::waiver(),
  y_symmetric = NULL,
  y_transform = NULL,
  col_breaks = NULL,
  col_breaks_n = 5,
  col_drop = FALSE,
  col_expand_limits = NULL,
  col_label = NULL,
  col_labels = NULL,
  col_legend_ncol = NULL,
  col_legend_nrow = NULL,
  col_legend_rev = FALSE,
  col_palette = NULL,
  col_palette_na = NULL,
  col_rescale = scales::rescale(),
  col_steps = FALSE,
  col_transform = NULL,
  facet_axes = NULL,
  facet_axis_labels = "margins",
  facet_drop = FALSE,
  facet_labels = NULL,
  facet_layout = NULL,
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_scales = "fixed",
  facet_space = "fixed",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  label_case = NULL
)
}
\arguments{
\item{data}{A data frame or tibble.}

\item{...}{Other arguments passed to within a \code{params} list in \code{layer()}.}

\item{stat}{A statistical transformation to use on the data. A snakecase character string of a ggproto Stat subclass object minus the Stat prefix (e.g. \code{"identity"}).}

\item{position}{A position adjustment. A snakecase character string of a ggproto Position subclass object minus the Position prefix (e.g. \code{"identity"}), or a \verb{position_*()} function that outputs a ggproto Position subclass object (e.g. \code{ggplot2::position_identity()}).}

\item{coord}{A coordinate system. A \verb{coord_*()} function that outputs a constructed ggproto Coord subclass object (e.g. \code{\link[ggplot2:coord_cartesian]{ggplot2::coord_cartesian()}}).}

\item{theme}{A ggplot2 theme (e.g. \code{\link[=light_mode_t]{light_mode_t()}} or \code{\link[=dark_mode_r]{dark_mode_r()}}). (Or a list that includes 1. a theme and 2. a \code{\link[ggplot2:labs]{ggplot2::labs()}} function. E.g. \verb{list(light_mode_r(), labs(colour = NULL, fill = NULL)}).}

\item{theme_orientation}{The orientation of plot, which affects the theme components that are removed. Either \code{"x"} or \code{"y"}.}

\item{theme_axis_line_rm}{\code{TRUE} or \code{FALSE} of whether to remove the relevant axis line per the \code{theme_orientation} of the plot.}

\item{theme_axis_ticks_rm}{\code{TRUE} or \code{FALSE} of whether to remove the relevant axis ticks per the \code{theme_orientation} of the plot.}

\item{theme_panel_grid_rm}{\code{TRUE} or \code{FALSE} of whether to remove the relevant panel grid per the \code{theme_orientation} of the plot.}

\item{blend}{The blending mode per \code{\link[ggblend:blend]{ggblend::blend()}} (e.g. "multiply").}

\item{x, xmin, xmax, xend, y, ymin, ymax, yend, z, col, facet, facet2, group, subgroup, label, text, sample}{An unquoted aesthetic variable.}

\item{mapping}{A set of additional aesthetic mappings in \code{\link[ggplot2:aes]{ggplot2::aes()}}. Intended primarily for non-supported aesthetics (e.g. \code{shape}, \code{linetype}, \code{linewidth}, or \code{size}), but can also be used for delayed evaluation etc.}

\item{x_breaks, y_breaks, col_breaks}{A \verb{scales::breaks_*} function (e.g. \verb{scales::breaks_*()}), or a vector of breaks.}

\item{x_breaks_n, y_breaks_n, col_breaks_n}{A number of desired breaks for when \verb{*_breaks = NULL}.}

\item{x_expand, y_expand}{Padding to the limits with the \code{\link[ggplot2:expansion]{ggplot2::expansion()}} function, or a vector of length 2 (e.g. \code{c(0, 0)}).}

\item{x_expand_limits, y_expand_limits, col_expand_limits}{For a continuous variable, any values that the limits should encompass (e.g. \code{0}). For a discrete scale, manipulate the data instead with \code{forcats::fct_expand}.}

\item{x_label, y_label, col_label}{Label for the axis or legend title. Use \code{+ ggplot2::labs(... = NULL)} for no title.}

\item{x_labels, y_labels, col_labels, facet_labels}{A function that takes the breaks as inputs (e.g. \verb{\\(x) stringr::str_to_sentence(x)} or \verb{scales::label_*()}), or a vector of labels. (Note this must be named for \code{facet_labels}).}

\item{x_position, y_position}{The position of the axis (i.e. \code{"left"}, \code{"right"}, \code{"bottom"} or \code{"top"}).If using \code{y_position = "top"} with a \verb{*_theme_*} theme, add \code{caption = ""} or \code{caption = "\\n"}.}

\item{x_sec_axis, y_sec_axis}{A secondary axis with \code{\link[ggplot2:sec_axis]{ggplot2::dup_axis()}} or  \code{\link[ggplot2:sec_axis]{ggplot2::sec_axis()}}.}

\item{x_symmetric, y_symmetric}{\code{TRUE} or \code{FALSE} of whether a symmetric scale.}

\item{x_transform, y_transform, col_transform}{For a continuous scale, a transformation object (e.g. \code{\link[scales:transform_log]{scales::transform_log10()}}) or character string of this minus the \code{transform_} prefix (e.g. \code{"log10"}).}

\item{col_drop, facet_drop}{For a discrete variable, FALSE or TRUE of whether to drop unused levels.}

\item{col_legend_ncol, col_legend_nrow}{The number of columns and rows in a legend guide.}

\item{col_legend_rev}{\code{TRUE} or \code{FALSE} of whether to reverse the elements of a legend guide. Defaults to \code{FALSE}.}

\item{col_palette}{A character vector of hex codes (or names) or a \verb{scales::pal_*()} function.}

\item{col_palette_na}{A hex code (or name) for the colour of \code{NA} values.}

\item{col_rescale}{For a continuous variable, a \code{scales::rescale()} function.}

\item{col_steps}{For a continuous variable, \code{TRUE} or \code{FALSE} of whether to colour in steps. Defaults to \code{FALSE}.}

\item{facet_axes}{Whether to add interior axes and ticks with \code{"margins"}, \code{"all"}, \code{"all_x"}, or \code{"all_y"}. Sometimes \verb{+ *_theme_*()} may be needed.}

\item{facet_axis_labels}{Whether to add interior axis labels with \code{"margins"}, \code{"all"}, \code{"all_x"}, or \code{"all_y"}.}

\item{facet_layout}{Whether the layout is to be \code{"wrap"} or \code{"grid"}. If \code{NULL} and a single \code{facet} (or \code{facet2}) argument is provided, then defaults to \code{"wrap"}. If \code{NULL} and both facet and facet2 arguments are provided, defaults to \code{"grid"}.}

\item{facet_ncol, facet_nrow}{The number of columns and rows of facet panels. Only applies to a facet layout of \code{"wrap"}.}

\item{facet_scales}{Whether facet scales should be \code{"fixed"} across facets, \code{"free"} in both directions, or free in just one direction (i.e. \code{"free_x"} or \code{"free_y"}). Defaults to \code{"fixed"}.}

\item{facet_space}{When the facet scales are \emph{not} \code{"fixed"}, whether facet space should be \code{"fixed"} across facets, \code{"free"} to be proportional in both directions, or free to be proportional in just one direction (i.e. \code{"free_x"} or \code{"free_y"}). Defaults to \code{"fixed"}.}

\item{title}{Title string.}

\item{subtitle}{Subtitle string.}

\item{caption}{Caption title string.}

\item{label_case}{A function to format the label of unlabelled variables. Defaults to \code{snakecase::to_sentence_case}.}
}
\value{
A ggplot object.
}
\description{
Create a crossbar ggplot with a wrapper around \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} + \link[ggplot2:geom_linerange]{geom_crossbar()}.
}
\examples{
library(ggplot2)
library(dplyr)

set_blanket()

data.frame(
  trt = factor(c(1, 1, 2, 2)),
  resp = c(1, 5, 3, 4),
  group = factor(c(1, 2, 1, 2)),
  upper = c(1.1, 5.3, 3.3, 4.2),
  lower = c(0.8, 4.6, 2.4, 3.6)
) |>
  gg_crossbar(
    x = trt,
    y = resp,
    ymin = lower,
    ymax = upper,
    col = group,
    width = 0.5,
    x_label = "Treatment",
    y_label = "Response",
    blend = "multiply",
  )

}
