% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diverging_lollipop_chart.R
\name{diverging_lollipop_chart}
\alias{diverging_lollipop_chart}
\title{Diverging Lollipop Chart}
\usage{
diverging_lollipop_chart(
  data,
  x,
  y,
  lollipop_colors = c("#1F77B4", "#FF7F0E"),
  line_size = 0.75,
  point_size = 3,
  text_color = "black",
  text_size = 10
)
}
\arguments{
\item{data}{Dataset to use for the diverging lollipop chart}

\item{x}{\code{character} or \code{factor} column of \code{data}}

\item{y}{\code{numeric} column of \code{data} representing the lollipop length}

\item{lollipop_colors}{A \code{character} vector of length 2 containing the
colors for the positive and negative lollipops}

\item{line_size}{\code{numeric}. Size of the lollipop 'stick'}

\item{point_size}{\code{numeric}. Size of the lollipop 'head'}

\item{text_color}{\code{character}. The color for the lollipop annotations}

\item{text_size}{\code{numeric} The size of the lollipop annotation text in pt}
}
\value{
An object of class \code{ggplot}
}
\description{
Easily create a diverging lollipop chart
}
\examples{
if (requireNamespace("tidyr")) {
  library(magrittr)
  data(biomedicalrevenue)
  biomedicalrevenue \%>\%
  dplyr::filter(year > 2016) \%>\%
  tidyr::pivot_wider(
    values_from = revenue,
    names_from = year,
    names_prefix = "revenue_"
  ) \%>\%
  dplyr::mutate(diff = revenue_2018 - revenue_2017) \%>\%
  diverging_lollipop_chart(company, diff)
}

data(mtcars)
mtcars_z <- dplyr::transmute(
  .data = mtcars,
  model = row.names(mtcars),
  hpz = scale(hp)
)

diverging_lollipop_chart(mtcars_z, model, hpz)

## Change the colors
diverging_lollipop_chart(mtcars_z, model, hpz, lollipop_colors = c("darkgreen", "darkred"))

## Increase the axis label font size
diverging_lollipop_chart(mtcars_z, model, hpz, text_size = 14)

## Display the axis label text in the same color as the bars
diverging_lollipop_chart(mtcars_z, model, hpz, text_color = c("#1F77B4", "#FF7F0E"))

}
\author{
Thomas Neitmann
}
