% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GGExtensions.R
\name{geom_bracket}
\alias{geom_bracket}
\title{Add Brackets with Labels to a ggplot}
\usage{
geom_bracket(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  arrow = NULL,
  parse = FALSE,
  bracket = TRUE,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{additional arguments passed on to \link[ggplot2:layer]{layer()}.}

\item{arrow}{\code{arrow}, the arrow appear at both ends of the brackets, created by \code{\link[grid:arrow]{grid::arrow()}}.}

\item{parse}{\code{logical}, whether to parse the labels as expressions and displayed as described in \link[grDevices:plotmath]{plotmath}.}

\item{bracket}{\code{logical}, whether to display the bracket. If \code{FALSE}, only the label will be displayed.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
\code{LayerInstance}, a layer that can be added to a ggplot.
}
\description{
Add brackets with labeled annotations to a ggplot.
}
\section{Aesthetics}{

\itemize{
\item required: \code{xmin}, \code{xmax}, \code{ymin}, \code{ymax}, \code{label}
\item optional: \code{angle}, \code{alpha}, \code{hjust}, \code{vjust}, \code{colour}, \code{family}, \code{fontsize}, \code{fontface}, \code{linetype}, \code{linewidth}, \code{lineheight}
}
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
ggplot(mpg, aes(class, displ)) +
  geom_boxplot() +
  annotate("bracket", xmin = 2, xmax = 4, ymin = 4.5, ymax = 5, label = "label",
           arrow = grid::arrow(type = "closed", length = unit(0.1, "inches")))
\dontshow{\}) # examplesIf}
}
\author{
HMU-WH
}
