% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_corset.R
\name{gg_corset}
\alias{gg_corset}
\title{CORSET PLOT}
\arguments{
\item{data}{The name of the data frame.}

\item{y_var1}{The name of measured variable at time 1.}

\item{y_var2}{The name of measured variable at time 2.}

\item{group}{The name of units measured at each time point such as 'ID'. The trajectories of these units are visualized by the lines of the corset plot.}

\item{c_var}{The name of variable to visualize by line colour, such as percent change, magnitude of change, or direction of change.}

\item{eyelets}{Optional (default is FALSE). If set to true, this will visualize one of two mean types by c_var, as defined by the 'e_type' argument.}

\item{e_type}{Optional eyelet type if the eyelets parameter is set to TRUE. One of "SE" or "SD". The default is standard error ("SE") means. Alternatively, standard deviations ("SD") with means can be specified, which include horizontal lines to denote +1 and -1 standard deviation. Note that the visualization of standard deviations works best in tandem with the faceted option.}

\item{faceted}{Optional (default is FALSE). If set to true, the c_var will be faceted.}

\item{facet_design}{Optional facet type when the faceted parameter is set to TRUE. One of "original","group", or "line". The default is "original", which provides facets void of any special features. The "group" option includes the overall distribution of the entire sample in the background of each facet (which defaults to the 'vio_fill' colour), alongside each distribution for each c_var group. The "line" option includes all individual trajectories in the background of each facet using a soft grey (default) or custom colour as chosen by 'line_col' argument.}

\item{vio_fill}{Optional (defaults to a soft black). Use to change the fill colour of the half violins.}

\item{line_size}{Optional. Use to change the size (thickness) of the lines which visualize the c_var. Default is 0.25.}

\item{line_col}{Optional custom colour of the background individual lines when the facet_design is set to "line". Defaults to a soft grey.}
}
\value{
ggplot2 graphical object
}
\description{
This function visualizes a corset plot in wide format.
}
\examples{

wide.df <- data.frame(id = c(1,2,3,4,5),
             time1 = c(3,4,7,5,6),
             time2  = c(5,5,7,3,0),
             change = c(28.57,14.29,0,-28.57,-85.71),
             direction = c("increase","increase","no change","decrease","decrease"))

gg_corset(data = wide.df, y_var1 = "time1", y_var2 = "time2",
          group = "id", c_var = "change")

## Create corset plots with eyelets:

gg_corset(data = wide.df, y_var1 = "time1", y_var2 = "time2",
          group = "id", c_var = "direction", eyelets = TRUE)

## Create faceted corset plots based on direction of change:

gg_corset(data = wide.df, y_var1 = "time1", y_var2 = "time2",
          group = "id", c_var = "direction", faceted = TRUE)

## Create faceted corset plots with standard deviation eyelets:

gg_corset(data = wide.df, y_var1 = "time1", y_var2 = "time2", group = "id",
          c_var = "direction", e_type = "SD", faceted = TRUE)

}
