% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_dag.R
\name{coordinates}
\alias{coordinates}
\alias{coords2df}
\alias{coords2list}
\title{Manipulate DAG coordinates}
\usage{
coords2df(coord_list)

coords2list(coord_df)
}
\arguments{
\item{coord_list}{a named list of coordinates}

\item{coord_df}{a data.frame with columns x, y, and name}
}
\value{
either a list or a data.frame with DAG node coordinates
}
\description{
Manipulate DAG coordinates
}
\examples{
library(dagitty)
coords <- list(
  x = c(A = 1, B = 2, D = 3, C = 3, F = 3, E = 4, G = 5, H = 5, I = 5),
  y = c(A = 0, B = 0, D = 1, C = 0, F = -1, E = 0, G = 1, H = 0, I = -1)
)
coord_df <- coords2df(coords)
coords2list(coord_df)

x <- dagitty("dag{
             G <-> H <-> I <-> G
             D <- B -> C -> I <- F <- B <- A
             H <- E <- C -> G <- D
             }")
coordinates(x) <- coords2list(coord_df)

}
