% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.SA}
\alias{autoplot.SA}
\title{Plot 'RJDemetra' model}
\usage{
\method{autoplot}{SA}(
  object,
  components = c("y", "sa", trend = "t", seasonal = "s", irregular = "i"),
  forecast = FALSE,
  ...
)
}
\arguments{
\item{object}{a \code{"SA"} or \code{"jSA"} model.}

\item{components}{components to print, can be \code{"y"} (input time series),
\code{"sa"} (seasonal adjusted), \code{"t"} (trend-cycle),
\code{"y_cal"} (calendar adjusted), \code{"s"} (seasonal), \code{"i"} (irregular),
\code{"cal"} (calendar). The vector can be named to change the label}

\item{forecast}{boolean indicating if the forecast series should be printed.}

\item{...}{unused arguments.}
}
\description{
Plot 'RJDemetra' model
}
\examples{
x = RJDemetra::jx13(ipi_c_eu[,"FR"])
ggplot2::autoplot(x)
}
