% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allFunctions.R
\name{buildPathDF}
\alias{buildPathDF}
\title{Build data frame for path representation}
\usage{
buildPathDF(path)
}
\arguments{
\item{path}{path object representing the path between two vertices}
}
\description{
This function builds a dataframe of information about the path object that can later be used
for visualization. The dataframe includes "label" (name of each variety) of each node,
"x" (the year of the variety, the x-axis value for which the label and
incoming/outgoing edges are centered), "y" (the y-axis value, which is the index
of the path, incremented by unity), "xstart" (the x-axis position of the 
outgoing edge (leaving to connect to the node at the next largest y-value)),
"xend" (the x-axis position of the outgoing edge (connected to the node at the
next largest y-value)), "ystart" (the y-axis position of the outgoing edge (leaving
to connect to the node at the next largest y-value), "yend" (the y-axis position
of the outgoing edge (connected to the node at the next largest y-value))).
}

