% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relabel.R
\name{gf_relabel}
\alias{gf_relabel}
\alias{print.gf_ggplot}
\title{Modify plot labeling}
\usage{
gf_relabel(plot, labels = get_variable_labels(plot$data), ...)

\method{print}{gf_ggplot}(x, labels = get_variable_labels(x$data), ...)
}
\arguments{
\item{plot}{A ggplot.}

\item{labels}{A named list of labels.}

\item{...}{Additional named labels. See examples.}

\item{x}{A ggplot.}
}
\value{
A plot with potentially modified labels.
}
\description{
Some packages like expss provide mechanisms for providing longer labels to R objects.
These labels can be used when labeling plots and tables, for example, without requiring
long or awkward variable names.  This is an experimental feature and currently only supports
expss or any other system that stores a label in the \code{label} attribute of a vector.
}
\examples{

# labeling using a list
labels <- list(width = "width of foot (cm)", length = "length of foot (cm)",
  domhand = "dominant hand")
gf_point(length ~ width, color = ~domhand, data = mosaicData::KidsFeet) |>
  gf_relabel(labels)

# labeling using ...
gf_point(length ~ width, color = ~domhand, data = mosaicData::KidsFeet) |>
  gf_relabel(
    width = "width of foot (cm)",
   length = "length of foot (cm)",
   domhand = "dominant hand")

# Alternatively, we can store labels with data.
KF <- mosaicData::KidsFeet |>
  set_variable_labels(
    length = 'foot length (cm)',
    width = 'foot width (cm)'
  )
gf_point(length ~ width, data = KF)
gf_density2d(length ~ width, data = KF)
get_variable_labels(KF)


}
