% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask.R
\name{with_mask}
\alias{with_mask}
\title{Apply a mask to a layer}
\usage{
with_mask(x, mask, invert = FALSE, ...)
}
\arguments{
\item{x}{A ggplot2 layer object, a ggplot, a grob, or a character string
naming a filter}

\item{mask}{The layer to use as mask. Can either be a string
identifying a registered filter, or a raster object. Will by default extract
the luminosity of the layer and use that as mask. To pick another channel use
one of the \link[=Channels]{channel specification} function.}

\item{invert}{Should the mask be inverted before applying it}

\item{...}{Arguments to be passed on to methods. See
\link[=object_support]{the documentation of supported object} for a description of
object specific arguments.}
}
\value{
Depending on the input, either a \code{grob}, \code{Layer}, list of \code{Layer}s,
\code{guide}, or \code{element} object. Assume the output can be used in the same
context as the input.
}
\description{
This filter applies a mask to the given layer, i.e. sets the opacity of the
layer based on another layer
}
\examples{
library(ggplot2)
volcano_raster <- as.raster((volcano - min(volcano))/diff(range(volcano)))
circle <- data.frame(
  x = cos(seq(0, 2*pi, length.out = 360)),
  y = sin(seq(0, 2*pi, length.out = 360))
)

ggplot() +
  as_reference(
    geom_polygon(aes(x = x, y = y), circle),
    id = 'circle'
  ) +
  with_mask(
    annotation_raster(volcano_raster, -1, 1, -1, 1, TRUE),
    mask = ch_alpha('circle')
  )

# use invert = TRUE to flip the mask
ggplot() +
  as_reference(
    geom_polygon(aes(x = x, y = y), circle),
    id = 'circle'
  ) +
  with_mask(
    annotation_raster(volcano_raster, -1, 1, -1, 1, TRUE),
    mask = ch_alpha('circle'),
    invert = TRUE
  )

}
\seealso{
Other blend filters: 
\code{\link{with_blend_custom}()},
\code{\link{with_blend}()},
\code{\link{with_interpolate}()}
}
\concept{blend filters}
