% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/element_part_rect.R
\name{element_part_rect}
\alias{element_part_rect}
\title{Partial rectangle theme element}
\usage{
element_part_rect(
  side = "tlbr",
  fill = NULL,
  colour = NULL,
  size = NULL,
  linetype = NULL,
  color = NULL,
  inherit.blank = FALSE
)
}
\arguments{
\item{side}{A \code{character} of length one containing any of \code{"t"},
\code{"l"}, \code{"b"}, \code{"r"}. If these letters are present it will
draw an edge at the top (t), left (l), bottom (b) or right (r)
respectively. Including all or none of these letters will default to normal
\code{element_rect()}.}

\item{fill}{Fill colour.}

\item{colour, color}{Line/border colour. Color is an alias for colour.}

\item{size}{Line/border size in mm; text size in pts.}

\item{linetype}{Line type. An integer (0:8), a name (blank, solid,
dashed, dotted, dotdash, longdash, twodash), or a string with
an even number (up to eight) of hexadecimal digits which give the
lengths in consecutive positions in the string.}

\item{inherit.blank}{Should this element inherit the existence of an
\code{element_blank} among its parents? If \code{TRUE} the existence of
a blank element among its parents will cause this element to be blank as
well. If \code{FALSE} any blank parent element will be ignored when
calculating final element state.}
}
\value{
An S3 object of class \code{element_part_rect}.
}
\description{
The \code{element_part_rect()} function draws sides of a rectangle as theme
elements. It can substitute \code{element_rect()} theme elements.
}
\examples{
ggplot(iris, aes(Sepal.Width, Sepal.Length)) +
  geom_point() +
  facet_grid(Species ~.) +
  theme(
    strip.background = element_part_rect(side = "tb", colour = "black"),
    panel.background = element_part_rect(side = "l", colour = "black")
  )
}
