% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip_themed.R
\name{strip_themed}
\alias{strip_themed}
\title{Strip with themed boxes and texts}
\usage{
strip_themed(
  clip = "inherit",
  size = "constant",
  text_x = NULL,
  text_y = NULL,
  background_x = NULL,
  background_y = NULL,
  by_layer_x = FALSE,
  by_layer_y = FALSE
)
}
\arguments{
\item{clip}{A \code{character(1)} that controls whether text labels are clipped to
the background boxes. Can be either \code{"inherit"} (default), \code{"on"} or
\code{"off"}.}

\item{size}{A \code{character(1)} stating that the strip margins in different
layers remain \code{"constant"} or are \code{"variable"}.}

\item{text_x, text_y}{A \code{list()} with
\code{\link[ggplot2:element]{element_text()}} elements. See details.}

\item{background_x, background_y}{A \code{list()} with
\code{\link[ggplot2:element]{element_rect()}} elements. See details.}

\item{by_layer_x, by_layer_y}{A \code{logical(1)} that when \code{TRUE}, maps the
different elements to different layers of the strip. When \code{FALSE}, maps the
different elements to individual strips, possibly repeating the elements
to match the number of strips through \code{rep_len()}.}
}
\value{
A \code{StripThemed} ggproto object that can be given as an argument to
facets in ggh4x.
}
\description{
A style of strips with individually themed strips.
}
\details{
With respect to the \verb{text_*} and \verb{background_*} arguments, they can
be a list with (a mix of) the following objects:
\itemize{
\item \code{NULL} indicates that the global plot theme applies.
\item \code{element_blank()} omits drawing the background or text.
\item An \code{element} class object inheriting from the \code{element_text} or
\code{element_rect} classes.
}

For constructing homogeneous lists of elements, the
\code{\link[=elem_list_text]{elem_list_text()}} and
\code{\link[=elem_list_rect]{elem_list_rect()}} are provided for convenience.
}
\examples{
# Some simple plot
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point()

# Set some theming options, we can use `element_blank()`
backgrounds <- list(element_blank(), element_rect(fill = "dodgerblue"))
# Or we could use `NULL` to use the global theme
texts <- list(element_text(colour = "red"), NULL, element_text(face = "bold"))

# Elements are repeated until the fit the number of facets
p + facet_wrap2(
  vars(drv, year),
  strip = strip_themed(
    background_x = backgrounds,
    text_x = texts
  )
)

# Except when applied to each layer instead of every strip
p + facet_wrap2(
  vars(drv, year),
  strip = strip_themed(
    background_x = backgrounds,
    text_x = texts,
    by_layer_x = TRUE
  )
)

# To conveniently distribute arguments over a list of the same elements,
# you can use the following wrappers:
p + facet_wrap2(
  vars(drv, year),
  strip = strip_themed(
    text_x = elem_list_text(colour = c("blue", "red")),
    background_x = elem_list_rect(fill = c("white", "grey80")),
    by_layer_x = TRUE
  )
)
}
\seealso{
Other strips: 
\code{\link{strip_nested}()},
\code{\link{strip_split}()},
\code{\link{strip_vanilla}()}
}
\concept{strips}
