% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip_tag.R
\name{strip_tag}
\alias{strip_tag}
\title{Strips as tags}
\usage{
strip_tag(
  clip = "inherit",
  order = c("x", "y"),
  just = c(0, 1),
  text_x = NULL,
  text_y = element_text(angle = 0),
  background_x = NULL,
  background_y = NULL,
  by_layer_x = FALSE,
  by_layer_y = FALSE
)
}
\arguments{
\item{clip}{A \code{character(1)} that controls whether text labels are clipped to
the background boxes. Can be either \code{"inherit"} (default), \code{"on"} or
\code{"off"}.}

\item{order}{Either \code{c("x", "y")} or \code{c("y", "x")}, setting the top-to-bottom
order of horizontal versus "vertical" labels in facets with a grid layout.}

\item{just}{A \verb{<numeric[2]>} setting the horizontal and vertical
justification of placing the textbox.}

\item{text_x, text_y}{A \code{list()} with
\code{\link[ggplot2:element]{element_text()}} elements. See details.}

\item{background_x, background_y}{A \code{list()} with
\code{\link[ggplot2:element]{element_rect()}} elements. See details.}

\item{by_layer_x, by_layer_y}{A \code{logical(1)} that when \code{TRUE}, maps the
different elements to different layers of the strip. When \code{FALSE}, maps the
different elements to individual strips, possibly repeating the elements
to match the number of strips through \code{rep_len()}.}
}
\value{
A \code{StripTag} ggproto object that can be given as an argument to
facets in ggh4x.
}
\description{
This strip style renders the strips as text with fitted boxes onto the panels
of the plot. This is in contrast to strips that match the panel size and
are located outside the panels.
}
\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy)) +
  geom_point()

# Typical use
p + facet_wrap2(
  ~ class,
  strip = strip_tag()
)

# Adjusting justification
p + facet_wrap2(
  ~ class,
  strip = strip_tag(just = c(1, 0))
)

p + facet_wrap2(
  ~ drv + year,
  strip = strip_tag()
)

# With a grid layout, you can control in which order the labels are drawn
p + facet_grid2(
  "vertical" ~ "horizontal",
  strip = strip_tag(order = c("x", "y")) # default
)

p +facet_grid2(
  "vertical" ~ "horizontal",
  strip = strip_tag(order = c("y", "x")) # invert order
)
}
\seealso{
Other strips: 
\code{\link{strip_nested}()},
\code{\link{strip_split}()},
\code{\link{strip_themed}()},
\code{\link{strip_vanilla}()}
}
\concept{strips}
