% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdr_bin.R
\name{hdr_bin}
\alias{hdr_bin}
\title{Binning highest density regions in one or two dimensions}
\usage{
hdr_bin(x, y = NULL, prob = c(0.5, 0.9, 0.99), ...)
}
\arguments{
\item{x}{Numeric vector}

\item{y}{Numeric vector of same length as x.}

\item{prob}{Probability coverage required for HDRs}

\item{...}{...}
}
\value{
probability coverage for each element of the numeric vectors.
}
\description{
Binning highest density regions in one or two dimensions
}
\examples{
library(ggplot2)

ggplot(data = faithful, aes(x = waiting, y = eruptions)) +
  geom_point(aes(colour = hdr_bin(x = waiting, y = eruptions)))
}
