% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lunar-calcs.R
\name{lunar_phase_polygon}
\alias{lunar_phase_polygon}
\title{Get the shape of the illuminated part of the moon}
\usage{
lunar_phase_polygon(date, longitude, latitude, n = 100)
}
\arguments{
\item{date}{A datetime object used to calculate the illuminated fraction of the moon}

\item{longitude, latitude}{Used to calculate zenith angle. This will result in a more accurate
shape of the moon as observed at the specified location.}

\item{n}{Number of coordinates in the returned polygon shape (should be even).}
}
\value{
Returns a \code{data.frame} with  coordinates of a polygon representing
the shape of the illuminated fraction of the moon.
}
\description{
Function that calculates coordinates of a polygon representing the shape of the
illuminated fraction of the moon, as observed from Earth. The shape has a radius
of 1 and is centred around (0, 0). It does not consider lunar eclipses.
}
\examples{
disc_illum <- lunar_phase_polygon(as.POSIXct("2025-04-01"))
plot(NA, NA, xlim = c(-1,1), ylim = c(-1, 1), asp = 1,
     xlab = "x coord", ylab = "y coord")
polygon(disc_illum$x, disc_illum$y, col = "white")

disc_illum <- lunar_phase_polygon(as.POSIXct("2025-04-01"), 5, 50)
plot(NA, NA, xlim = c(-1,1), ylim = c(-1, 1), asp = 1,
     xlab = "x coord", ylab = "y coord")
polygon(disc_illum$x, disc_illum$y, col = "white")
}
\author{
Pepijn de Vries
}
