% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-structure.R
\name{str}
\alias{str}
\alias{str.ggplot}
\title{Show the structure of a ggplot object.}
\usage{
\method{str}{ggplot}(object, ..., max.level = 1, components = TRUE,
  vec.len = 2, list.len = 99, give.attr = FALSE, comp.str = "$ ",
  nest.lev = 0, indent.str = paste(rep.int(" ", max(0, nest.lev + 1)),
  collapse = ".."), size = TRUE)
}
\arguments{
\item{object}{ggplot Plot object with embedded data.}

\item{...}{accept additional parameter arguments}

\item{max.level}{integer Maximum depth of recursion (of lists within lists
...) to be printed.}

\item{components}{Vector of components to print, as indexes into
\code{object}.}

\item{vec.len}{integer Approximate maximum length allowed when showing the
first few values of a vector.}

\item{list.len}{integer Maximum number of components to show of any list that
will be described.}

\item{give.attr}{logical Flag, determining whether a description of
attributes will be shown.}

\item{comp.str}{character String to be used for separating list components.}

\item{nest.lev}{numeric current nesting level in the recursive calls to
\code{str()}.}

\item{indent.str}{character String used for each level of indentation.}

\item{size}{logical Flag, should the size of the object in bytes be printed?}
}
\value{
A NULL is returned invisibly. While a description of the
  structure of \code{p} or its components will be printed in outline form as
  a "side-effect", with indentation for each level of recursion, showing the
  internal storage mode, class(es) if any, attributes, and first few
  elements of each data vector. By default each level of list recursion is
  indicated and attributes enclosed in angle brackets.
}
\description{
A \code{str()} method tailored to objects of class \code{"ggplot"}. It adds
to the output the size of the object, and the ability to subset
individual components.
}
\examples{
library(ggplot2)

p <- ggplot(mpg, aes(factor(year), (cty + hwy) / 2)) +
  geom_boxplot() +
  geom_point(color = "red") +
  facet_grid(. ~ class) +
  ggtitle("Example plot")

p

# str(p) vs. summary(p)
str(p, max.level = 1, size = FALSE)
summary(p)

# structure of p at 2 levels of nesting
str(p, max.level = 2)

# top level structure and size of p
str(p, max.level = 0)

# structure and size of p["data"]
str(p, components = "data")

}
\seealso{
A \code{summary()} method for class \code{ggplot} is defined by
  package 'ggplot2'. Method \code{summary()} provides a more compact
  description of \code{"ggplot"} objects than method \code{str()}. Here we
  provide a wrapper on R's \code{str()} with different default arguments. A
  summary does not directly describe how the different components of an R
  object are stored, while the structure does.
}
