% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-summary-address.R
\name{stat_summary_address}
\alias{stat_summary_address}
\title{Summarize IP addresses on a heatmap}
\usage{
stat_summary_address(
  mapping = NULL,
  data = NULL,
  ...,
  fun = NULL,
  fun.args = list(),
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{fun}{Summary function (see section below for details). If \code{NULL} (the
default), the observations are simply counted.}

\item{fun.args}{A list of extra arguments to pass to \code{fun}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
Addresses are grouped into networks determined by the \code{pixel_prefix} argument
of \code{coord_ip()}. Then the \code{z} values are summarized with summary function \code{fun}.
}
\section{Aesthetics}{

\code{stat_summary_address()} understands the following aesthetics (required
aesthetics are in bold):
\itemize{
\item \strong{\code{ip}}: An \code{\link[ipaddress:ip_address]{ip_address}} column
\item \code{z}: Value passed to the summary function (required if \code{fun} is used)
\item \code{fill}: Default is \code{after_stat(value)}
\item \code{alpha}
}
}

\section{Computed variables}{

The following variables are available to \code{\link[ggplot2:aes_eval]{after_stat()}}:
\itemize{
\item \code{value}: Value of summary statistic
\item \code{count}: Number of observations
}
}

\section{Summary function}{

The \code{data} might contain multiple rows per pixel of the heatmap, so a summary
function reduces this information to a single value to display.
This function receives the \code{data} column specified by the \code{z} aesthetic
and also receives arguments specified by \code{fun.args}.

The \code{fun} argument can be specified in multiple ways:
\describe{
\item{\code{NULL}}{If no summary function is provided, the number of observations
is computed. In this case, you don't need to specify the \code{z} aesthetic,
and the computed variables \code{value} and \code{count} will be equal.}
\item{string}{The name of an existing function (e.g. \code{fun = "mean"}).}
\item{function}{Either provide an existing function (e.g. \code{fun = mean}) or
define a new function (e.g. \code{fun = function(x) sum(x^2)}).}
\item{formula}{A function can also be created from a formula. This uses \code{.x}
as the summarized variable (e.g. \code{fun = ~ sum(.x^2)}).}
}
}

\examples{
dat <- data.frame(
  ip = sample_ipv4(10000),
  weight = runif(10000)
)

p <- ggplot(dat, aes(ip = ip)) +
  coord_ip() +
  theme_ip_light()

# simple count of observations
p +
  stat_summary_address() +
  scale_fill_viridis_c(trans = "log2", na.value = "black", guide = "none")

# compute mean weight
p +
  stat_summary_address(aes(z = weight), fun = ~ mean(.x)) +
  scale_fill_viridis_c(na.value = "black", guide = "none")
}
