% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_polygon_interactive.R
\name{geom_map_interactive}
\alias{geom_map_interactive}
\title{interactive polygons from a reference map.}
\usage{
geom_map_interactive(mapping = NULL, data = NULL, map, stat = "identity",
  na.rm = FALSE, show.legend = NA, inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, see \code{\link[ggplot2]{geom_point}}.}

\item{data}{A data frame, see \code{\link[ggplot2]{geom_point}}.}

\item{map}{Data frame that contains the map coordinates. See \code{\link[ggplot2]{geom_map}}.}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string, see \code{\link[ggplot2]{geom_point}}.}

\item{na.rm}{See \code{\link[ggplot2]{geom_point}}.}

\item{show.legend}{See \code{\link[ggplot2]{geom_point}}.}

\item{inherit.aes}{See \code{\link[ggplot2]{geom_point}}.}

\item{...}{other arguments passed on to layer. See \code{\link[ggplot2]{geom_point}}.}
}
\description{
The geometry is based on \code{\link[ggplot2]{geom_map}}.
See the documentation for those functions for more details.
}
\examples{
# add interactive maps to a ggplot -------
library(ggplot2)

crimes <- data.frame(state = tolower(rownames(USArrests)), USArrests)

# create tooltips and onclick events
states_ <- sprintf("<p>\%s</p>",
                   as.character(crimes$state) )
table_ <- paste0(
  "<table><tr><td>UrbanPop</td>",
  sprintf("<td>\%.0f</td>", crimes$UrbanPop),
  "</tr><tr>",
  "<td>Assault</td>",
  sprintf("<td>\%.0f</td>", crimes$Assault),
  "</tr></table>"
)

onclick <- sprintf(
  "window.open(\\"\%s\%s\\")",
  "http://en.wikipedia.org/wiki/",
  as.character(crimes$state)
)


crimes$labs <- paste0(states_, table_)
crimes$onclick = onclick

if (require("maps") ) {
  states_map <- map_data("state")
  gg_map <- ggplot(crimes, aes(map_id = state))
  gg_map <- gg_map + geom_map_interactive(aes(
                  fill = Murder,
                  tooltip = labs,
                  data_id = state,
                  onclick = onclick
                ),
                map = states_map) +
    expand_limits(x = states_map$long, y = states_map$lat)
  ggiraph(code = print(gg_map))
}

}
\seealso{
\code{\link{ggiraph}}
}
