% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggHeatmap.R
\name{ggHeatmap}
\alias{ggHeatmap}
\title{Make an interactive Heatmap}
\usage{
ggHeatmap(data, mapping, stat = "count", palette = "Blues",
  reverse = FALSE, addlabel = FALSE, polar = FALSE, interactive = FALSE,
  yangle = 0, color = "grey50", size = 0.1, use.label = TRUE,
  use.labels = TRUE, ...)
}
\arguments{
\item{data}{A data.frame}

\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{stat}{The statistical transformation to use on the data for this layer, as a string
c("count","identity")}

\item{palette}{A palette name used for discrete fill var, Default value is "Blues"}

\item{reverse}{If true, reverse palette colors}

\item{addlabel}{A logical value. If TRUE, label will be added to the plot}

\item{polar}{A logical value. If TRUE, coord_polar() function will be added}

\item{interactive}{A logical value. If TRUE, an interactive plot will be returned}

\item{yangle}{A integer. The value will be used adjust the angle of axis.text.y}

\item{color}{Color argument passed on to geom_rect_interactive.}

\item{size}{Size argument passed on to geom_rect_interactive.}

\item{use.label}{Logical. Whether or not use column label in case of labelled data}

\item{use.labels}{Logical. Whether or not use value labels in case of labelled data}

\item{...}{other arguments passed on to geom_rect_interactive.}
}
\value{
An interactive barplot
}
\description{
Make an interactive Heatmap
}
\examples{
require(moonBook)
require(ggplot2)
require(ggiraph)
require(sjmisc)
ggHeatmap(acs,aes(x=Dx,y=smoking),addlabel=TRUE,interactive=TRUE)
ggHeatmap(acs,aes(x=sex,y=Dx,fill=age),addlabel=TRUE,interactive=TRUE)
ggHeatmap(rose,aes(x=Month,y=group,fill=value),stat="identity",addlabel=TRUE)
ggHeatmap(rose,aes(x=Month,y=group,fill=value),addlabel=TRUE)
ggHeatmap(taco,aes(x=AgeGroup,y=Filling,fill=Rating,facet=ShellType),color="grey50",stat="identity")
}
