% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geocode.R
\name{geocode}
\alias{geocode}
\alias{geocodeQueryCheck}
\title{Geocode}
\usage{
geocode(location, output = c("latlon", "latlona", "more", "all"),
  source = c("google", "dsk"), messaging = FALSE, force = ifelse(source ==
  "dsk", FALSE, TRUE), sensor = FALSE, override_limit = FALSE,
  client = "", signature = "", nameType = c("long", "short"), data)

geocodeQueryCheck(userType = "free")
}
\arguments{
\item{location}{a character vector of street addresses or place
names (e.g. "1600 pennsylvania avenue, washington dc" or
"Baylor University")}

\item{output}{amount of output, "latlon", "latlona", "more", or
"all"}

\item{source}{"dsk" for Data Science Toolkit or "google" for
Google}

\item{messaging}{turn messaging on/off}

\item{force}{force online query, even if previously downloaded}

\item{sensor}{whether or not the geocoding request comes from a
device with a location sensor}

\item{override_limit}{override the current query count
(.GoogleGeocodeQueryCount)}

\item{client}{client ID for business users, see
\url{https://developers.google.com/maps/documentation/business/webservices/auth}}

\item{signature}{signature for business users, see
\url{https://developers.google.com/maps/documentation/business/webservices/auth}}

\item{nameType}{in some cases, Google returns both a long name
and a short name. this parameter allows the user to specify
which to grab.}

\item{data}{deprecated in 2.5, use \code{\link{mutate_geocode}}}

\item{userType}{User type, "free" or "business"}
}
\value{
If \code{output} is "latlon", "latlona", or "more", a
  data frame. If all, a list.
}
\description{
Geocodes a location (find latitude and longitude) using either
(1) the Data Science Toolkit
(\url{http://www.datasciencetoolkit.org/about}) or (2) Google
Maps. Note that when using Google you are agreeing to the Google
Maps API Terms of Service at
\url{https://developers.google.com/maps/terms}.
}
\details{
Note that the Google Maps api limits to 2500 queries a day. Use
\code{geocodeQueryCheck} to determine how many queries remain.
}
\examples{

\dontrun{ # Server response can be slow; this cuts down check time.

# types of input
geocode("houston texas")
geocode("baylor university") # see known issues below
geocode("1600 pennsylvania avenue, washington dc")
geocode("the white house")
geocode(c("baylor university", "salvation army waco"))




# types of output
geocode("houston texas", output = "latlona")
geocode("houston texas", output = "more")
geocode("Baylor University", output = "more")
str(geocode("Baylor University", output = "all"))


# see how many requests we have left with google
geocodeQueryCheck()
geocode("one bear place, waco, texas")
geocode("houston texas", force = TRUE)



# known issues :
# (1) source = "dsk" can't reliably geocode colloquial place names
geocode("city hall houston")
geocode("rice university")


}

}
\author{
David Kahle \email{david.kahle@gmail.com}
}
\seealso{
\code{\link{mutate_geocode}},
  \url{http://code.google.com/apis/maps/documentation/geocoding/}
}

