% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation-function.R
\name{dot_product}
\alias{dot_product}
\alias{andrews}
\alias{legendre}
\title{Transformation Coefficients}
\usage{
andrews(p = 4, k = 50 * (p - 1), ...)

legendre(p = 4, k = 50 * (p - 1), ...)
}
\arguments{
\item{p}{The number of dimensions}

\item{k}{The sequence length}

\item{...}{Other arguments passed on to methods. Mainly used for customized transformation function}
}
\value{
A list contains two named components
\enumerate{
  \item vector: A length \code{k} vector (define the domain)
  \item matrix: A \code{p\*k} transformed coefficient matrix
}
}
\description{
The dimension of the original data set is \code{n\*p}. It can be projected
onto a \code{n\*k} space. The functions below are to provide such transformations, e.g.
the \code{Andrews coefficient} (a Fourier transformation) and the \code{Legendre} polynomials.
}
\examples{
x <- andrews(p = 4)
dat <- iris[, -5]
proj <- t(as.matrix(dat) \%*\% x$matrix)
matplot(x$vector, proj,
        type = "l", lty = 1,
        col = "black",
        xlab = "x",
        ylab = "Andrews coefficients",
        main = "Iris")
}
\references{
Andrews, David F. "Plots of high-dimensional data." \emph{Biometrics} (1972): 125-136.

Abramowitz, Milton, and Irene A. Stegun, eds. "Chapter 8"
\emph{Handbook of mathematical functions with formulas, graphs, and mathematical tables}.
Vol. 55. US Government printing office, 1948.
}
