% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-edges.R
\name{geom_edgetext_repel}
\alias{geom_edgetext_repel}
\alias{geom_edgelabel_repel}
\title{Draw repulsive edge labels.}
\usage{
geom_edgetext_repel(
  mapping = NULL,
  data = NULL,
  parse = FALSE,
  ...,
  box.padding = unit(0.25, "lines"),
  label.padding = unit(0.25, "lines"),
  point.padding = unit(1e-06, "lines"),
  label.r = unit(0.15, "lines"),
  label.size = 0.25,
  arrow = NULL,
  force = 1,
  max.iter = 10000,
  nudge_x = 0,
  nudge_y = 0,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

geom_edgelabel_repel(
  mapping = NULL,
  data = NULL,
  parse = FALSE,
  ...,
  box.padding = unit(0.25, "lines"),
  label.padding = unit(0.25, "lines"),
  point.padding = unit(1e-06, "lines"),
  label.r = unit(0.15, "lines"),
  label.size = 0.25,
  arrow = NULL,
  force = 1,
  max.iter = 10000,
  nudge_x = 0,
  nudge_y = 0,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2]{aes}} or
\code{\link[ggplot2]{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), is combined with the default mapping at the top level of the
plot. You only need to supply \code{mapping} if there isn't a mapping
defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{parse}{If TRUE, the labels will be parsed into expressions and
displayed as described in ?plotmath}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. There are
  three types of arguments you can use here:

  \itemize{
    \item Aesthetics: to set an aesthetic to a fixed value, like
       \code{colour = "red"} or \code{size = 3}.
    \item Other arguments to the layer, for example you override the
      default \code{stat} associated with the layer.
    \item Other arguments passed on to the stat.
  }}

\item{box.padding}{Amount of padding around bounding box, as unit or number.
Defaults to 0.25. (Default unit is lines, but other units can be specified
by passing \code{unit(x, "units")}).}

\item{label.padding}{Amount of padding around label, as unit or number.
Defaults to 0.25. (Default unit is lines, but other units can be specified
by passing \code{unit(x, "units")}).}

\item{point.padding}{Amount of padding around labeled point, as unit or
number. Defaults to 0. (Default unit is lines, but other units can be
specified by passing \code{unit(x, "units")}).}

\item{label.r}{Radius of rounded corners, as unit or number. Defaults
to 0.15. (Default unit is lines, but other units can be specified by
passing \code{unit(x, "units")}).}

\item{label.size}{Size of label border, in mm.}

\item{arrow}{specification for arrow heads, as created by \code{\link[grid]{arrow}}}

\item{force}{Force of repulsion between overlapping text labels. Defaults
to 1.}

\item{max.iter}{Maximum number of iterations to try to resolve overlaps.
Defaults to 10000.}

\item{nudge_x}{Horizontal and vertical adjustments to nudge the
starting position of each text label. The units for \code{nudge_x} and
\code{nudge_y} are the same as for the data units on the x-axis and y-axis.}

\item{nudge_y}{Horizontal and vertical adjustments to nudge the
starting position of each text label. The units for \code{nudge_x} and
\code{nudge_y} are the same as for the data units on the x-axis and y-axis.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\description{
All arguments to both \code{\link{geom_edgetext_repel}} and
\code{\link{geom_edgelabel_repel}} are identical to those of
\code{\link[ggrepel]{geom_label_repel}}. \code{\link{geom_text_repel}} and
\code{\link{geom_label_repel}} produce strictly identical results.
}
\examples{
if (require(network) && require(sna)) {
  data(flo, package = "network")
  n <- network(flo, directed = FALSE)

  # arbitrary categorical edge attribute
  e <- sample(1:4, network.edgecount(n), replace = TRUE)
  set.edge.attribute(n, "day", e)

  # with repulsive edge labels
  ggplot(n, aes(x, y, xend = xend, yend = yend)) +
    geom_edges() +
    geom_edgetext_repel(aes(label = day), box.padding = unit(0.5, "lines")) +
    geom_nodes(size = 4, colour = "grey50") +
    theme_blank()

  # repulsive edge labels for only a subset of all edges
  edge_day <- function(x) {
    x[ x$day > 2, ]
  }
  ggplot(n, aes(x, y, xend = xend, yend = yend)) +
    geom_edges(aes(colour = cut(day, (4:0)[ -3 ]))) +
    geom_edgetext_repel(aes(
      label = paste("day", day),
      colour = cut(day, (4:0)[ -3 ])
    ), data = edge_day) +
    geom_nodes(size = 4, colour = "grey50") +
    scale_colour_manual("day",
      labels = c("old ties", "day 3", "day 4"),
      values = c("grey50", "gold", "tomato")
    ) +
    theme_blank()
}

}
