## ----setup, include=FALSE------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)


library(ggparliament)
library(dplyr)
library(ggplot2)
require(tidyr)
require(magrittr)
require(purrr)

source("../R/parliament_data.R")
source("../R/geom_parliament_seats.R")
source("../R/geom_highlight_government.R")
source("../R/helper_funcs.R")
source("../R/draw_majoritythreshold.R")
source("../R/draw_partylabels.R")
source("../R/draw_majoritythreshold.R")
source("../R/draw_totalseats.R")
source("../R/theme_ggparliament.R")
load("../R/sysdata.rda")



## ------------------------------------------------------------------------
usa <- election_data %>%
  filter(country == "USA" &
    house == "Representatives")  %>% 
  split(.$year) %>% # split
  map(~parliament_data(election_data = ., # apply
  party_seats = .$seats,
  parl_rows = 8,
  type = "semicircle")) %>%
  bind_rows() # combine

## ---- fig.width=12, fig.height=4-----------------------------------------
us <- ggplot(usa, aes(x, y, colour = party_short)) +
  geom_parliament_seats() + 
  geom_highlight_government(government == 1) + 
  labs(colour = NULL, 
       title = "American Congress",
       subtitle = "The party that has control of US Congress is encircled in black.") +
  theme_ggparliament() +
  scale_colour_manual(values = usa$colour, 
                      limits = usa$party_short) + 
  theme(legend.position = 'bottom') + 
  facet_grid(~year, scales = 'free') 

us

## ------------------------------------------------------------------------
australia <- election_data %>%
  filter(country == "Australia" &
    year == "2016")  %>% 
  split(.$house) %>% # split
  map(~parliament_data(election_data = ., # apply
  party_seats = .$seats,
  parl_rows = 4,
  type = "horseshoe")) %>%
  bind_rows() # combine

## ----fig.width=8, fig.height=5-------------------------------------------
au <- ggplot(australia, aes(x, y, colour=party_short, type = "horseshoe")) +
  geom_parliament_seats() + 
  geom_highlight_government(government == 1) + 
  labs(colour = NULL, 
       title = "Australian Parliament",
       subtitle = "Government encircled in black.") +
  scale_colour_manual(values = australia$colour, 
                      limits = australia$party_short) + 
  theme_ggparliament() +
  theme(legend.position = 'bottom') + 
  facet_grid(~house, scales = 'free')

au


## ------------------------------------------------------------------------
uk<- election_data %>%
  filter(country == "UK")  %>%
  split(.$year) %>%
  map(~parliament_data(election_data = .,
  party_seats = .$seats,
  group = .$government,
  type = "opposing_benches")) %>%
  bind_rows()


## ------------------------------------------------------------------------
ggplot(data = uk, 
       aes(x = x,
           y = y,
           color = party_long)) +
  geom_parliament_seats(size = 1.5) +  
  coord_flip() + 
  facet_wrap(~year, ncol = 2) + 
  scale_color_manual(values = uk$colour, 
                     limits = uk$party_long) +
  theme_ggparliament()


