% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotation-logticks.r
\name{annotation_logticks}
\alias{annotation_logticks}
\title{Annotation: log tick marks}
\usage{
annotation_logticks(base = 10, sides = "bl", scaled = TRUE,
  short = unit(0.1, "cm"), mid = unit(0.2, "cm"), long = unit(0.3, "cm"),
  colour = "black", size = 0.5, linetype = 1, alpha = 1, color = NULL,
  ...)
}
\arguments{
\item{base}{the base of the log (default 10)}

\item{sides}{a string that controls which sides of the plot the log ticks appear on.
It can be set to a string containing any of \code{"trbl"}, for top, right,
bottom, and left.}

\item{scaled}{is the data already log-scaled? This should be \code{TRUE}
(default) when the data is already transformed with \code{log10()} or when
using \code{scale_y_log10}. It should be \code{FALSE} when using
\code{coord_trans(y = "log10")}.}

\item{short}{a \code{\link[grid]{unit}} object specifying the length of the
short tick marks}

\item{mid}{a \code{\link[grid]{unit}} object specifying the length of the
middle tick marks. In base 10, these are the "5" ticks.}

\item{long}{a \code{\link[grid]{unit}} object specifying the length of the
long tick marks. In base 10, these are the "1" (or "10") ticks.}

\item{colour}{Colour of the tick marks.}

\item{size}{Thickness of tick marks, in mm.}

\item{linetype}{Linetype of tick marks (\code{solid}, \code{dashed}, etc.)}

\item{alpha}{The transparency of the tick marks.}

\item{color}{An alias for \code{colour}.}

\item{...}{Other parameters passed on to the layer}
}
\description{
This annotation adds log tick marks with diminishing spacing.
These tick marks probably make sense only for base 10.
}
\examples{
# Make a log-log plot (without log ticks)
a <- ggplot(msleep, aes(bodywt, brainwt)) +
 geom_point(na.rm = TRUE) +
 scale_x_log10(
   breaks = scales::trans_breaks("log10", function(x) 10^x),
   labels = scales::trans_format("log10", scales::math_format(10^.x))
 ) +
 scale_y_log10(
   breaks = scales::trans_breaks("log10", function(x) 10^x),
   labels = scales::trans_format("log10", scales::math_format(10^.x))
 ) +
 theme_bw()

a + annotation_logticks()                # Default: log ticks on bottom and left
a + annotation_logticks(sides = "lr")    # Log ticks for y, on left and right
a + annotation_logticks(sides = "trbl")  # All four sides

# Hide the minor grid lines because they don't align with the ticks
a + annotation_logticks(sides = "trbl") + theme(panel.grid.minor = element_blank())

# Another way to get the same results as 'a' above: log-transform the data before
# plotting it. Also hide the minor grid lines.
b <- ggplot(msleep, aes(log10(bodywt), log10(brainwt))) +
 geom_point(na.rm = TRUE) +
 scale_x_continuous(name = "body", labels = scales::math_format(10^.x)) +
 scale_y_continuous(name = "brain", labels = scales::math_format(10^.x)) +
 theme_bw() + theme(panel.grid.minor = element_blank())

b + annotation_logticks()

# Using a coordinate transform requires scaled = FALSE
t <- ggplot(msleep, aes(bodywt, brainwt)) +
  geom_point() +
  coord_trans(x = "log10", y = "log10") +
  theme_bw()
t + annotation_logticks(scaled = FALSE)

# Change the length of the ticks
a + annotation_logticks(
  short = unit(.5,"mm"),
  mid = unit(3,"mm"),
  long = unit(4,"mm")
)
}
\seealso{
\code{\link{scale_y_continuous}}, \code{\link{scale_y_log10}} for log scale
  transformations.

\code{\link{coord_trans}} for log coordinate transformations.
}

