% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggproto.r
\name{ggproto}
\alias{ggproto}
\alias{ggproto_parent}
\title{Create a new ggproto object}
\usage{
ggproto(`_class` = NULL, `_inherit` = NULL, ...)

ggproto_parent(parent, self)
}
\arguments{
\item{_class}{Class name to assign to the object. This is stored as the class
attribute of the object. If \code{NULL} (the default), no class name will
be added to the object.}

\item{_inherit}{ggproto object to inherit from. If \code{NULL}, don't inherit
from any object.}

\item{...}{A list of members in the ggproto object.}

\item{parent, self}{Access parent class \code{parent} of object \code{self}.}
}
\description{
ggproto is inspired by the proto package, but it has some important
differences. Notably, it cleanly supports cross-package inheritance, and has
faster performance.
}
\section{Calling ggproto methods}{


ggproto methods can take an optional \code{self} argument: if it is present,
it is a regular method; if it's absent, it's a "static" method (i.e. it
doesn't use any fields).

Imagine you have a ggproto object \code{Adder}, which has a
method \code{addx = function(self, n) n + self$x}. Then, to call this
function, you would use \code{Adder$addx(10)} -- the \code{self} is passed
in automatically by the wrapper function. \code{self} be located anywhere
in the function signature, although customarily it comes first.
}

\section{Calling methods in a parent}{


To explicitly call a methods in a parent, use
\code{ggproto_parent(Parent, self)}.
}

