% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-summary-2d.r, R/stat-summary-hex.r
\name{stat_summary_2d}
\alias{stat_summary2d}
\alias{stat_summary_2d}
\alias{stat_summary_hex}
\title{Bin and summarise in 2d (rectangle & hexagons)}
\usage{
stat_summary_2d(mapping = NULL, data = NULL, geom = "tile",
  position = "identity", bins = 30, binwidth = NULL, drop = TRUE,
  fun = "mean", fun.args = list(), na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)

stat_summary_hex(mapping = NULL, data = NULL, geom = "hex",
  position = "identity", bins = 30, binwidth = NULL, drop = TRUE,
  fun = "mean", fun.args = list(), na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link{aes}} or \code{\link{aes_string}}. Only needs to be set
at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points
on this layer}

\item{bins}{numeric vector giving number of bins in both vertical and
horizontal directions. Set to 30 by default.}

\item{binwidth}{Numeric vector giving bin width in both vertical and
horizontal directions. Overrides \code{bins} if both set.}

\item{drop}{drop if the output of \code{fun} is \code{NA}.}

\item{fun}{function for summary.}

\item{fun.args}{A list of extra arguments to pass to \code{fun}}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with
a warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}

\item{...}{other arguments passed on to \code{\link{layer}}. This can
include aesthetics whose values you want to set, not map. See
\code{\link{layer}} for more details.}
}
\description{
\code{stat_summary_2d} is a 2d variation of \code{\link{stat_summary}}.
\code{stat_summary_hex} is a hexagonal variation of
\code{\link{stat_summary_2d}}. The data are divided into bins defined
by \code{x} and \code{y}, and then the values of \code{z} in each cell is
are summarised with \code{fun}.
}
\section{Aesthetics}{

\itemize{
 \item \code{x}: horizontal position
 \item \code{y}: vertical position
 \item \code{z}: value passed to the summary function
}
}
\examples{
d <- ggplot(diamonds, aes(carat, depth, z = price))
d + stat_summary_2d()

# Specifying function
d + stat_summary_2d(fun = function(x) sum(x^2))
d + stat_summary_2d(fun = var)
d + stat_summary_2d(fun = "quantile", fun.args = list(probs = 0.1))

if (requireNamespace("hexbin")) {
d + stat_summary_hex()
}
}
\seealso{
\code{\link{stat_summary_hex}} for hexagonal summarization.
  \code{\link{stat_bin2d}} for the binning options.
}

