% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-debug-panel.R
\name{stat_debug_panel}
\alias{stat_debug_panel}
\title{Print to console data received by the compute panel function.}
\usage{
stat_debug_panel(mapping = NULL, data = NULL, geom = "null",
  summary.fun = tibble::as_tibble, summary.fun.args = list(),
  position = "identity", na.rm = FALSE, show.legend = FALSE,
  inherit.aes = TRUE, ...)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_string}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{summary.fun}{A function used to print the \code{data} object received as
input.}

\item{summary.fun.args}{A list.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{na.rm}{a logical value indicating whether NA values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\description{
\code{stat_debug} reports all distinct values in \code{group}
  and \code{PANEL}, and \code{nrow}, \code{ncol} and the names of the columns
  or variables, and the class of x and y for each panel in a ggplot as passed to the
  \code{compute_panel} function in the \code{ggproto} object.
}
\section{Computed variables}{

\describe{
  \item{x}{x at centre of range}
  \item{y}{y at centre of range}
  \item{nrow}{\code{nrow()} of \code{data} object}
  \item{ncol}{\code{ncol()} of \code{data} object}
  \item{colnames}{\code{colnames()} of \code{data} object}
  \item{colclasses}{\code{class()} of \code{x} and \code{y} columns in \code{data} object}
  \item{group}{all distinct values in group as passed in \code{data} object}
  \item{PANEL}{all distinct values in PANEL as passed in \code{data} object}
  }
}
\examples{
library(ggplot2)
my.df <- data.frame(x = rep(1:10, 2),
                    y = rep(c(1,2), c(10,10)),
                    group = rep(c("A","B"), c(10,10)))
ggplot(my.df, aes(x,y)) + geom_point() + stat_debug_panel()
ggplot(my.df, aes(x,y, colour = group)) + geom_point() + stat_debug_panel()
ggplot(my.df, aes(x,y)) + geom_point() + facet_wrap(~group) + stat_debug_panel()

}
\seealso{
Other diagnosis.functions: \code{\link{stat_debug_group}}
}

