% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-fit-broom.R
\name{stat_fit_glance}
\alias{stat_fit_glance}
\title{One row summary data frame for a fitted model}
\usage{
stat_fit_glance(
  mapping = NULL,
  data = NULL,
  geom = "text_npc",
  method = "lm",
  method.args = list(formula = y ~ x),
  glance.args = list(),
  label.x = "left",
  label.y = "top",
  hstep = 0,
  vstep = 0.075,
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs
to be set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific data set - only needed if you want to override
the plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{method}{character or function.}

\item{method.args, glance.args}{list of arguments to pass to \code{method}
and to [generics::glance()], respectively.}

\item{label.x, label.y}{\code{numeric} with range 0..1 "normalized parent
coordinates" (npc units) or character if using \code{geom_text_npc()} or
\code{geom_label_npc()}. If using \code{geom_text()} or \code{geom_label()}
numeric in native data units. If too short they will be recycled.}

\item{hstep, vstep}{numeric in npc units, the horizontal and vertical step
used between labels for different groups.}

\item{position}{The position adjustment to use for overlapping points on this
layer}

\item{na.rm}{a logical indicating whether NA values should be stripped before
the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\value{
The output of the \code{glance()} methods is returned almost as is in
  the \code{data} object, as a data frame. The names of the columns in the
  returned data are consistent with those returned by method \code{glance()}
  from package 'broom', that will frequently differ from the name of values
  returned by the print methods corresponding to the fit or test function
  used. To explore the values returned by this statistic including the name
  of variables/columns, which vary depending on the model fitting function
  and model formula we suggest the use of
  \code{\link[gginnards]{geom_debug}}. An example is shown below.
}
\description{
\code{stat_fit_glance} fits a model and returns a "tidy" version
  of the model's fit, using '\code{glance()} methods from packages 'broom',
  'broom.mixed', or other sources.
}
\details{
\code{stat_fit_glance} together with \code{\link{stat_fit_tidy}}
  and \code{\link{stat_fit_augment}}, based on package 'broom' can be used
  with a broad range of model fitting functions as supported at any given
  time by package 'broom'. In contrast to \code{\link{stat_poly_eq}} wich can
  generate text or expression labels automatically, for these functions the
  mapping of aesthetic \code{label} needs to be explicitly supplied in the
  callm, and labels built on the fly.

  A ggplot statistic receives as data a data frame that is not the one passed
  as argument by the user, but instead a data frame with the variables mapped
  to aesthetics. In other words, it respects the grammar of graphics and
  consequently within arguments passed through \code{method.args} names of
  aesthetics like $x$ and $y$ should be used intead of the original variable
  names, while data is automatically passed the data frame. This helps ensure
  that the model is fitted to the same data as plotted in other layers.
}
\note{
Although arguments passed to parameter \code{glance.args} will be
  passed to [generics::glance()] whether they are silently ignored or obeyed
  depends on each specialization of [glance()], so do carefully read the
  documentation for the version of [glance()] corresponding to the `method`
  used to fit the model.
}
\section{Warning!}{
 Not all `glance()` methods are defined in package 'broom'.
  `glance()` especializations for mixed models fits of classes `lme`, `nlme`,
  `lme4`, and many others are defined in package 'broom.mixed'.
}

\section{Handling of grouping}{
 \code{stat_fit_glance} applies the function
  given by \code{method} separately to each group of observations, and
  factors mapped to aesthetics generate a separate group for each factor
  level. Because of this, \code{stat_fit_glance} is not useful for annotating
  plots with results from \code{t.test()}, ANOVA or ANCOVA. In such cases use
  the \code{stat_fit_tb()} statistic which applies the model fitting per
  panel.
}

\section{Model formula required}{
 The current implementation works only with
  methods that accept a formula as argument and which have a \code{data}
  parameter through which a data frame can be passed. For example,
  \code{lm()} should be used with the formula interface, as the evaluation of
  \code{x} and \code{y} needs to be delayed until the internal \code{object}
  of the ggplot is available.  With some methods like \code{cor.test()} the
  data embedded in the \code{"ggplot"} object cannot be automatically passed
  as argument for the \code{data} parameter of the test or model fit
  function.
}

\examples{
# package 'broom' needs to be installed to run these examples

if (requireNamespace("broom", quietly = TRUE)) {
  library(broom)
  library(quantreg)

# Inspecting the returned data using geom_debug()
  if (requireNamespace("gginnards", quietly = TRUE)) {
    library(gginnards)

    ggplot(mtcars, aes(x = disp, y = mpg)) +
      stat_smooth(method = "lm") +
      geom_point(aes(colour = factor(cyl))) +
      stat_fit_glance(method = "lm",
                    method.args = list(formula = y ~ x),
                    geom = "debug")
  }

# Regression by panel example
  ggplot(mtcars, aes(x = disp, y = mpg)) +
    stat_smooth(method = "lm") +
    geom_point(aes(colour = factor(cyl))) +
    stat_fit_glance(method = "lm",
                    label.y = "bottom",
                    method.args = list(formula = y ~ x),
                    mapping = aes(label = sprintf('r^2~"="~\%.3f~~italic(P)~"="~\%.2g',
                                  after_stat(r.squared), after_stat(p.value))),
                    parse = TRUE)

# Regression by group example
  ggplot(mtcars, aes(x = disp, y = mpg, colour = factor(cyl))) +
    stat_smooth(method = "lm") +
    geom_point() +
    stat_fit_glance(method = "lm",
                    label.y = "bottom",
                    method.args = list(formula = y ~ x),
                    mapping = aes(label = sprintf('r^2~"="~\%.3f~~italic(P)~"="~\%.2g',
                                  after_stat(r.squared), after_stat(p.value))),
                    parse = TRUE)

# Weighted regression example
  ggplot(mtcars, aes(x = disp, y = mpg, weight = cyl)) +
    stat_smooth(method = "lm") +
    geom_point(aes(colour = factor(cyl))) +
    stat_fit_glance(method = "lm",
                    label.y = "bottom",
                    method.args = list(formula = y ~ x, weights = quote(weight)),
                    mapping = aes(label = sprintf('r^2~"="~\%.3f~~italic(P)~"="~\%.2g',
                                  after_stat(r.squared), after_stat(p.value))),
                    parse = TRUE)

# correlation test
  ggplot(mtcars, aes(x = disp, y = mpg)) +
    geom_point() +
    stat_fit_glance(method = "cor.test",
                    label.y = "bottom",
                    method.args = list(formula = ~ x + y),
                    mapping = aes(label = sprintf('r[Pearson]~"="~\%.3f~~italic(P)~"="~\%.2g',
                                  after_stat(estimate), after_stat(p.value))),
                    parse = TRUE)

  ggplot(mtcars, aes(x = disp, y = mpg)) +
    geom_point() +
    stat_fit_glance(method = "cor.test",
                    label.y = "bottom",
                    method.args = list(formula = ~ x + y, method = "spearman", exact = FALSE),
                    mapping = aes(label = sprintf('r[Spearman]~"="~\%.3f~~italic(P)~"="~\%.2g',
                                  after_stat(estimate), after_stat(p.value))),
                    parse = TRUE)

# Quantile regression by group example
  ggplot(mtcars, aes(x = disp, y = mpg)) +
    stat_smooth(method = "lm") +
    geom_point() +
    stat_fit_glance(method = "rq",
                    label.y = "bottom",
                    method.args = list(formula = y ~ x),
                    mapping = aes(label = sprintf('AIC = \%.3g, BIC = \%.3g',
                                  after_stat(AIC), after_stat(BIC))))

}

}
\seealso{
\code{\link[broom]{broom}} and \code{broom.mixed} for details on how
  the tidying of the result of model fits is done.

Other ggplot statistics for model fits: 
\code{\link{stat_fit_augment}()},
\code{\link{stat_fit_deviations}()},
\code{\link{stat_fit_residuals}()},
\code{\link{stat_fit_tb}()},
\code{\link{stat_fit_tidy}()}
}
\concept{ggplot statistics for model fits}
