% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-lexis.R, R/stat-lexis.R
\name{geom_lexis}
\alias{geom_lexis}
\alias{stat_lexis}
\title{Display events of different cohorts in form of a lexis charts}
\usage{
geom_lexis(
  mapping = NULL,
  data = NULL,
  ...,
  point_show = TRUE,
  point_colour = NULL,
  point_size = NULL,
  gap_filler = TRUE,
  lineend = "round",
  linejoin = "round",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_lexis(
  mapping = NULL,
  data = NULL,
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{point_show}{logical. Should a point be shown at the end
of each segment? TRUE by default}

\item{point_colour}{color of a point}

\item{point_size}{the size of a point}

\item{gap_filler}{logical. Should gaps be filled?
TRUE by default}

\item{lineend}{line end style (round, butt, square)}

\item{linejoin}{line join style (round, mitre, bevel)}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\description{
This geom can be used to plot 45° lifelines for a cohort.
Lexis diagrams are named after Wilhelm Lexis and used by demographers
for more than a century.
}
\details{
This geom draws 45° lines from the start to the end of a 'lifetime'. It is
a combination of a segment, and a point.
Besides \code{y} and \code{yend} coordinates this geom creates one additional variable
called \code{type} in the layer data. You might want to map to an aesthetic with
\code{\link[ggplot2:aes_eval]{ggplot2::after_stat()}}, see Examples section and \code{vignette("ggpointless")}
for more details.

Rows in your data with either missing \code{x} or \code{xend} values will be removed
(your segments must start and end somewhere).
}
\section{Aesthetics}{

geom_lexis() understands the following aesthetics (required
aesthetics are in bold):
\itemize{
\item \strong{x}
\item \strong{xend}
\item alpha
\item color
\item fill
\item group
\item shape
\item size
\item linetype
\item stroke
}
}

\examples{
df1 <- data.frame(
  key = c("A", "B", "B", "C", "D", "E"),
  start = c(0, 1, 6, 5, 6, 9),
  end = c(5, 4, 10, 9, 8, 11)
)
p <- ggplot(df1, aes(x = start, xend = end, color = key))
p +
  geom_lexis()
p +
  geom_lexis(gap_filler = FALSE)
p +
  geom_lexis(aes(linetype = after_stat(type)),
    point_show = FALSE
  )

# change point appearance
p + geom_lexis(
  point_colour = "black",
  point_size = 3,
  shape = 21,
  fill = "white",
  stroke = 1
)

# missing values will be removed
df2 <- data.frame(
  key = c("A", "B", "B", "C", "D"),
  start = c(0, 1, 7, 5, 6),
  end = c(5, 4, 13, 9, NA)
)
ggplot(df2, aes(x = start, xend = end, color = key)) +
  geom_lexis()

# Ideally, `x` values should be increasing, unlike
# in the next example
df3 <- data.frame(x = Sys.Date() - 0:2, xend = Sys.Date() + 1:3)
ggplot(df3, aes(x = x, xend = xend)) +
  geom_lexis()

# If `x` is of class Date, `xend` can't be of class `POSIXt` or
# `POSIXct`. The error is thrown by the `scales::date_trans` function.
\dontrun{
ggplot(
  data.frame(x = Sys.Date(), xend = Sys.time()),
  aes(x = x, xend = xend)
) +
  geom_lexis()
}

}
