% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_boxjitter.R
\name{geom_boxjitter}
\alias{geom_boxjitter}
\title{A hybrid boxplot.}
\usage{
geom_boxjitter(mapping = NULL, data = NULL, stat = "BoxJitter",
  position = "dodge", ..., outlier.colour = NULL, outlier.color = NULL,
  outlier.fill = NULL, outlier.shape = 19, outlier.size = 1.5,
  outlier.stroke = 0.5, outlier.alpha = NULL, outlier.intersect = FALSE,
  jitter.colour = NULL, jitter.color = NULL, jitter.fill = NULL,
  jitter.shape = 19, jitter.size = 1.5, jitter.stroke = 0.5,
  jitter.alpha = NULL, jitter.width = NULL, jitter.height = NULL,
  jitter.seed = NULL, boxplot.expand = FALSE, notch = FALSE,
  notchwidth = 0.5, varwidth = FALSE, errorbar.draw = FALSE,
  errorbar.length = 0.5, na.rm = FALSE, show.legend = NA,
  inherit.aes = TRUE)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link{aes}} or
\code{\link{aes_}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
   options:

   If \code{NULL}, the default, the data is inherited from the plot
   data as specified in the call to \code{\link{ggplot}}.

   A \code{data.frame}, or other object, will override the plot
   data. All objects will be fortified to produce a data frame. See
   \code{\link{fortify}} for which variables will be created.

   A \code{function} will be called with a single argument,
   the plot data. The return value must be a \code{data.frame.}, and
   will be used as the layer data.}

\item{stat}{Use to override the default connection between
\code{geom_boxplot} and \code{stat_boxplot}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link{layer}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{color = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{outlier.colour}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
  aesthetics used for the box.

  In the unlikely event you specify both US and UK spellings of colour, the
  US spelling will take precedence.}

\item{outlier.color}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
  aesthetics used for the box.

  In the unlikely event you specify both US and UK spellings of colour, the
  US spelling will take precedence.}

\item{outlier.fill}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
  aesthetics used for the box.

  In the unlikely event you specify both US and UK spellings of colour, the
  US spelling will take precedence.}

\item{outlier.shape}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
  aesthetics used for the box.

  In the unlikely event you specify both US and UK spellings of colour, the
  US spelling will take precedence.}

\item{outlier.size}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
  aesthetics used for the box.

  In the unlikely event you specify both US and UK spellings of colour, the
  US spelling will take precedence.}

\item{outlier.stroke}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
  aesthetics used for the box.

  In the unlikely event you specify both US and UK spellings of colour, the
  US spelling will take precedence.}

\item{outlier.alpha}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
  aesthetics used for the box.

  In the unlikely event you specify both US and UK spellings of colour, the
  US spelling will take precedence.}

\item{outlier.intersect}{Defaults to `FALSE`. If set to `TRUE`, outliers will be part of the jitter-plot
(but keeping the given outlier graphical parameters) rather than plotted vertically above / below the whisker lines.}

\item{jitter.colour, jitter.color, jitter.fill, jitter.shape, jitter.size, jitter.stroke, jitter.alpha}{Default aesthetics for jitter, set to `NULL` to inherit from the aesthetics used for the box.}

\item{jitter.width}{Width passed to position_jitter. Defaults to half the width of the boxplot.}

\item{jitter.height}{Height passed to position_jitter. Defaults to 40 percent of the resolution.}

\item{jitter.seed}{Seed passed to position_jitter for reproducible jittering.}

\item{boxplot.expand}{Defaults to `FALSE`. If set to `TRUE`, the full boxplots will be plotted.}

\item{notch}{if \code{FALSE} (default) make a standard box plot. If
\code{TRUE}, make a notched box plot. Notches are used to compare groups;
if the notches of two boxes do not overlap, this suggests that the medians
are significantly different.}

\item{notchwidth}{for a notched box plot, width of the notch relative to
the body (default 0.5)}

\item{varwidth}{if \code{FALSE} (default) make a standard box plot. If
\code{TRUE}, boxes are drawn with widths proportional to the
square-roots of the number of observations in the groups (possibly
weighted, using the \code{weight} aesthetic).}

\item{errorbar.draw}{Draw horizontal whiskers at the top and bottom (the IQR). Defaults to `FALSE`.}

\item{errorbar.length}{Length of the horizontal whiskers (errorbar). Defaults to half the width of the half-boxplot,
or half the width of the entire boxplot if `boxplot.expand` is set to `TRUE`.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link{borders}}.}
}
\description{
Half boxplot, half scatterplot with customizable jitter.
}
\examples{
set.seed(221)
df <- data.frame(score = rgamma(150, 4, 1), 
                 gender = sample(c("M", "F"), 150, replace = TRUE), 
                 genotype = factor(sample(1:3, 150, replace = TRUE)))

ggplot(df) + geom_boxjitter(aes(x = gender, y = score, fill = genotype),
                            jitter.shape = 21, jitter.color = NA, 
                            jitter.height = 0, jitter.width = 0.04,
                            outlier.color = NA, errorbar.draw = TRUE) +
  scale_fill_manual(values = c("#CF3721", "#31A9B8", "#258039")) +
  theme_minimal()
}
