% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-margin-point.r
\name{geom_x_margin_point}
\alias{geom_x_margin_point}
\alias{geom_y_margin_point}
\title{Reference points on the margins}
\usage{
geom_x_margin_point(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  xintercept,
  sides = "b",
  point.shift = 0.017,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = FALSE
)

geom_y_margin_point(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  yintercept,
  sides = "l",
  point.shift = 0.017,
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = FALSE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}}. Only needs to be set at the layer level if you
are overriding the plot defaults.}

\item{data}{A layer specific dataset - only needed if you want to override
the plot defaults.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{xintercept, yintercept}{numeric Parameters that control the position of
the marginal points. If these are set, data, mapping and show.legend are
overridden.}

\item{sides}{A string that controls which sides of the plot the rugs appear
on. It can be set to a string containing any combination of \code{"trbl"},
for top, right, bottom, and left.}

\item{point.shift}{numeric value expressed in npc units for the shift of the
rug points inwards from the edge of the plotting area.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
A plot layer instance.
}
\description{
Margin points can supplement a 2d display with annotations. Margin points
can highlight individual values along a margin. The geometries
\code{geom_x_margin_point()} and \code{geom_y_margin_point()} behave
similarly \code{geom_vline()} and \code{geom_hline()} and share their "double
personality" as both annotations and geometries.
}
\examples{
p <- ggplot(mtcars, aes(wt, mpg)) +
       geom_point()
p
p + geom_x_margin_point(xintercept = 3.5)
p + geom_y_margin_point(yintercept = c(18, 28, 15))
p + geom_x_margin_point(data = data.frame(x = c(2.5, 4.5)),
                        mapping = aes(xintercept = x))
p + geom_x_margin_point(data = data.frame(x = c(2.5, 4.5)),
                        mapping = aes(xintercept = x),
                        sides = "tb")

}
\seealso{
Other Geometries for marginal annotations in ggplots: 
\code{\link{geom_x_margin_arrow}()},
\code{\link{geom_x_margin_grob}()}
}
\concept{Geometries for marginal annotations in ggplots}
