% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guide_prism_bracket.R
\name{draw_prism_bracket}
\alias{draw_prism_bracket}
\title{Grob for bracket axes}
\usage{
draw_prism_bracket(
  break_positions,
  break_labels,
  axis_position,
  theme,
  check.overlap = FALSE,
  angle = NULL,
  n.dodge = 1,
  width = NULL,
  outside = TRUE
)
}
\arguments{
\item{break_positions}{Position of bracket center and labels}

\item{break_labels}{Labels between ticks}

\item{axis_position}{Position of axis (top, bottom, left or right)}

\item{theme}{A complete \code{\link[ggplot2]{theme}} object}

\item{check.overlap}{Silently remove overlapping labels,
(recursively) prioritizing the first, last, and middle labels.}

\item{angle}{Compared to setting the angle in
\code{\link[ggplot2]{theme}} / \code{element_text},
this also uses some heuristics to automatically pick the \code{hjust} and
\code{vjust} that you probably want.}

\item{n.dodge}{The number of rows (for vertical axes) or columns (for
horizontal axes) that should be used to render the labels. This is
useful for displaying labels that would otherwise overlap.}

\item{width}{\code{numeric}. Controls the width of the bracket. Try
values between 0 and 1.}

\item{outside}{\code{logical}. Default is \code{TRUE} and brackets point
outwards. If \code{FALSE} the bracket crossbar is moved so the ticks appear
to point inwards towards the plotting area.}
}
\description{
Grob for bracket axes.
}
\keyword{internal}
