% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grids.R
\name{grids}
\alias{grids}
\title{Add Grids to a ggplot}
\usage{
grids(axis = c("xy", "x", "y"), color = "grey92", size = NULL,
  linetype = NULL)
}
\arguments{
\item{axis}{axis for which grid should be added. Allowed values include \code{c("xy", "x", "y")}.}

\item{color}{grid line color.}

\item{size}{numeric value specifying grid line size.}

\item{linetype}{line type. An integer (0:8), a name (blank, solid, dashed,
dotted, dotdash, longdash, twodash). Sess \code{\link{show_line_types}}.}
}
\description{
Add grids to ggplot.
}
\examples{
# Load data
data("ToothGrowth")

# Basic plot
p <- ggboxplot(ToothGrowth, x = "dose", y = "len")
p

# Add border
p + grids(linetype = "dashed")
}
