% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_igraph.R
\name{layout_igraph_dendrogram}
\alias{layout_igraph_dendrogram}
\title{Apply a dendrogram layout to layout_igraph}
\usage{
layout_igraph_dendrogram(graph, circular = FALSE, offset = pi/2,
  direction = "out")
}
\arguments{
\item{graph}{An igraph object}

\item{circular}{Logical. Should the layout be transformed to a circular
representation. Defaults to \code{FALSE}.}

\item{offset}{If \code{circular = TRUE}, where should it begin. Defaults to
\code{pi/2} which is equivalent to 12 o'clock.}

\item{direction}{The direction to the leaves. Defaults to 'out'}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{circular} and
\code{leaf} as well as any information stored as vertex attributes on the
igraph object.
}
\description{
This layout mimicks the \code{\link[igraph]{layout_as_tree}} algorithm
supplied by igraph, but puts all leaves at 0 and builds it up from there,
instead of starting from the root and building it from there. The height of
branch points are related to the maximum distance to an edge from the branch
node.
}
\note{
This function is not intended to be used directly but by setting
\code{layout = 'dendrogram'} in \code{\link{create_layout}}
}
\seealso{
Other layout_igraph_*: \code{\link{layout_igraph_auto}},
  \code{\link{layout_igraph_circlepack}},
  \code{\link{layout_igraph_hive}},
  \code{\link{layout_igraph_linear}},
  \code{\link{layout_igraph_manual}},
  \code{\link{layout_igraph_partition}},
  \code{\link{layout_igraph_treemap}}
}
