% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_igraph.R
\name{layout_igraph_treemap}
\alias{layout_igraph_treemap}
\title{Calculate nodes as rectangels subdividing that of their parent}
\usage{
layout_igraph_treemap(graph, algorithm = "split", weight = NULL,
  circular = FALSE, sort.by = NULL, direction = "out", height = 1,
  width = 1)
}
\arguments{
\item{graph}{An igraph object}

\item{algorithm}{The name of the tiling algorithm to use. Defaults to 'split'}

\item{weight}{An optional vertex attribute to use as weight. Will only affect
the weight of leaf nodes as the weight of non-leaf nodes are derived from
their children.}

\item{circular}{Logical. Should the layout be transformed to a circular
representation. Ignored.}

\item{sort.by}{The name of a vertex attribute to sort the nodes by.}

\item{direction}{The direction of the tree in the graph. \code{'out'} (default)
means that parents point towards their children, while \code{'in'} means that
children point towards their parent.}

\item{height}{The height of the bounding rectangle}

\item{width}{The width of the bounding rectangle}
}
\value{
A data.frame with the columns \code{x}, \code{y}, \code{width},
\code{height}, \code{leaf}, \code{depth}, \code{circular} as well as any
information stored as vertex attributes on the igraph object.
}
\description{
A treemap is a space filling hierarchical layout that maps nodes to
rectangles. The rectangles of the children of a node is packed into the
rectangle of the node so that the size of a rectangle is a function of the
size of the children. The size of the leaf nodes can be mapped arbitrarily
(defaults to 1). Many different algorithms exists for dividing a rectangle
into smaller bits, some optimizing the aspect ratio and some focusing on the
ordering of the rectangles. See details for more discussions on this. The
treemap layout was first developed by Ben Shneiderman for visualizing disk
usage in the early '90 and has seen many improvements since.
}
\details{
Different approaches to dividing the rectangles in a treemap exists; all with
their strengths and weaknesses. Currently only the split algorithm is
implemented which strikes a good balance between aspect ratio and order
preservation, but other, more well-known, algorithms such as squarify and
slice-and-dice will eventually be implemented.

\strong{Algorithms}

\emph{Split} (default)

The Split algorithm was developed by Bjorn Engdahl in order to address the
downsides of both the original slice-and-dice algorithm (poor aspect ratio)
and the popular squarify algorithm (no ordering of nodes). It works by
finding the best cut in the ordered list of children in terms of making sure
that the two rectangles associated with the split will have optimal aspect
ratio.
}
\note{
Treemap is a layout intended for trees, that is, graphs where nodes
only have one parent and zero or more children. If the provided graph does
not fit this format an attempt to convert it to such a format will be made.
}
\references{
Engdahl, B. (2005). \emph{Ordered and unordered treemap algorithms and their
applications on handheld devices}. Master's Degree Project.

Johnson, B., & Ben Shneiderman. (1991). \emph{Tree maps: A Space-Filling
Approach to the Visualization of Hierarchical Information Structures}. IEEE
Visualization, 284-291. \url{http://doi.org/10.1109/VISUAL.1991.175815}
}
\seealso{
Other layout_igraph_*: \code{\link{layout_igraph_auto}},
  \code{\link{layout_igraph_circlepack}},
  \code{\link{layout_igraph_dendrogram}},
  \code{\link{layout_igraph_hive}},
  \code{\link{layout_igraph_linear}},
  \code{\link{layout_igraph_manual}},
  \code{\link{layout_igraph_partition}}
}
