% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggroups.R
\docType{package}
\name{ggroups-package}
\alias{ggroups-package}
\title{Pedigree and genetic groups}
\description{
This package contains pedigree processing and analyzing functions, including functions for checking and renumbering the pedigree, making the pedigree relationship matrix and its inverse, in matrix and tabular formats, as well as functions related to genetic groups.
}
\details{
First, it is recommended to check the pedigree \code{data.frame} with the \code{pedcheck} function. Pedigree relationship matrix and its inverse are fundamentals in the conventional and modern animal breeding. The concept of genetic groups stems from the fact that not all the unknown parents are of the same genetic level. The genetic group contribution matrix (\strong{Q}) is required to weight and add genetic group effects (\ifelse{latex}{\out{$\hat{\bf g}$}}{\ifelse{html}{\out{<b>&gcirc;</b>}}{ghat}}) to the genetic merit of animals (\ifelse{latex}{\out{$\hat{\bf u}$}}{\ifelse{html}{\out{<b>&ucirc;</b>}}{uhat}}), which is equal to \strong{Q}\ifelse{latex}{\out{$\hat{\bf g}$}}{\ifelse{html}{\out{<b>&gcirc;</b>}}{ghat}} + \ifelse{latex}{\out{$\hat{\bf u}$}}{\ifelse{html}{\out{<b>&ucirc;</b>}}{uhat}} (Quaas, 1988). Calculating \strong{Q} is computationally challenging, and for large pedigree, large RAM and long computational time is required. Therefore, the functions \code{qmatL} and its parallel version, \code{qmatXL} are introduced. Overlap between sire and dam genetic groups is supported.
}
\references{
Quaas, R. L. 1988. Additive Genetic Model with Groups and Relationships. J. Dairy Sci., 71:1338-1345. <doi:10.3168.jds.S0022-0302(88)79691-5>
}
\author{
Mohammad Ali Nilforooshan \email{m.a.nilforooshan@gmail.com}
}
