% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_rollapplyr.R
\name{stat_rollapplyr}
\alias{stat_rollapplyr}
\title{Rolling summary Stat}
\usage{
stat_rollapplyr(mapping = NULL, data = NULL, geom = "line",
  position = "identity", show.legend = NA, inherit.aes = TRUE, width,
  align = "right", FUN = mean, index.ref = NULL, index.basis = 100, ...)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[=aes]{aes()}} or
\code{\link[=aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[=ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[=fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame.}, and
will be used as the layer data.}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[=borders]{borders()}}.}

\item{width}{The width to which the rolling version of FUN is applied}

\item{align}{specifies whether the transformed series should be left or 
right-aligned or centered compared to the rolling window of observations}

\item{FUN}{summary function, usually some kind of average, to apply on a rolling basis}

\item{index.ref}{if not NULL, a vector of integers indicating which elements of
the beginning of each series to use as a reference point for converting to an index.  
If NULL, no conversion takes place and the data are presented on the original scale.}

\item{index.basis}{if index.ref is not NULL, the basis point for converting
to an index, most commonly 100 or 1000.  See examples.}

\item{...}{other arguments for the geom}
}
\description{
Calculates a rolling summary, usually rolling average, on the fly for ggplot2
}
\details{
Calculates a rolling summary (usually rolling average) on the fly
for purposes of plotting with ggplot2.
}
\examples{
ap_df <- tsdf(AirPassengers)

ggplot(ap_df, aes(x = x, y = y)) +
   stat_rollapplyr(width = 12)
   
# rolling average after converting to an index, 1000 = average value
# in the first 12 months.
ggplot(ap_df, aes(x = x, y = y)) +
   stat_rollapplyr(width = 12, index.ref = 1:12, index.basis = 1000)

ggplot(ldeaths_df, aes(x = YearMon, y = deaths, colour = sex)) +
  geom_point() +
  facet_wrap(~sex) +
  stat_rollapplyr(width = 12, FUN = median) +
  ggtitle("Seasonally adjusted lung deaths")

}
\seealso{
\code{\link{decompose}}

Other time series stats for ggplot2: \code{\link{stat_decomp}},
  \code{\link{stat_index}}, \code{\link{stat_seas}},
  \code{\link{stat_stl}}
}
