% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggside.R
\name{xside}
\alias{xside}
\title{The xside geometries}
\value{
geom_xside* return a XLayer object to be added to a ggplot
}
\description{
\code{xside} refers to the api of ggside. Any \code{geom_} with
\code{xside} will plot its respective geometry along the x-axis
per facet panel. By default the xside panel will plot above the main
panel. This xside panel will always share the same scale as it's main
panel, but is expected to have a separate y-axis scaling.
}
\section{New Aesthetics}{


All \code{xside} Geometries have \code{xfill}, \code{xcolour}/\code{xcolor} available for
aesthetic mappings. These mappings behave exactly like the default
counterparts except that they are considered separate scales. All
\code{xside} geometries will use \code{xfill} over \code{fill}, but will default
to \code{fill} if \code{xfill} is not provided. The same goes for \code{xcolour} in
respects to \code{colour}. This comes in handy if you wish to map both \code{fill}
to one geometry as continuous, you can still map \code{xfill} for a separate
\code{xside} geometry without conflicts. See more information in
\code{vignette("ggside")}.
}

\section{Exported Geometries}{


The following are the \code{xside} variants of the \link{ggplot2} Geometries

\itemize{
\item \link{geom_xsidebar}
\item \link{geom_xsideboxplot}
\item \link{geom_xsidecol}
\item \link{geom_xsidedensity}
\item \link{geom_xsidefreqpoly}
\item \link{geom_xsidehistogram}
\item \link{geom_xsideline}
\item \link{geom_xsidepath}
\item \link{geom_xsidepoint}
\item \link{geom_xsidetext}
\item \link{geom_xsidetile}
\item \link{geom_xsideviolin}
}
}

\seealso{
\link{yside}
}
