% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-source-spct.r
\name{plot.source_spct}
\alias{plot.source_spct}
\title{Plot method for light-source spectra.}
\usage{
\method{plot}{source_spct}(x, ...,
  w.band = getOption("photobiology.plot.bands", default = list(UVC(), UVB(),
  UVA(), PAR())), range = NULL,
  unit.out = getOption("photobiology.radiation.unit", default = "energy"),
  label.qty = "total",
  annotations = getOption("photobiology.plot.annotations", default =
  c("boxes", "labels", "summaries", "colour.guide", "peaks")),
  text.size = 2.5)
}
\arguments{
\item{x}{a source_spct object}

\item{...}{other arguments passed along, such as \code{label.qty}}

\item{w.band}{a single waveband object or a list of waveband objects}

\item{range}{an R object on which range() returns a vector of length 2, with
min annd max wavelengths (nm)}

\item{unit.out}{character string indicating type of radiation units to use
for plotting: "photon" or its synomin "quantum", or "energy"}

\item{label.qty}{character string giving the type of summary quantity to use
for labels}

\item{annotations}{a character vector}

\item{text.size}{numeric size of text in the plot decorations.}
}
\value{
a \code{ggplot} object.
}
\description{
This function returns a ggplot object with an annotated plot of a source_spct
object.
}
\note{
Note that scales are expanded so as to make space for the annotations.
  The object returned is a ggplot objects, and can be further manipulated.
}
\examples{
library(photobiology)
plot(sun.spct)
plot(sun.spct, unit.out = "photon")
plot(sun.daily.spct)
plot(sun.daily.spct, unit.out = "photon")

}
\seealso{
Other plot functions: \code{\link{plot.cps_spct}},
  \code{\link{plot.filter_spct}},
  \code{\link{plot.object_spct}},
  \code{\link{plot.raw_spct}},
  \code{\link{plot.reflector_spct}},
  \code{\link{plot.response_spct}},
  \code{\link{plot.waveband}}
}
\keyword{hplot}

